package cn.gtmap.realestate.supervise.server.common.impl;

import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.server.model.CheckResult;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/4/18
 * @description 检测结果工具管理类
 */
@Service
public class CheckResultManage {

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 文件结果数据
     */
    private Map<FileMessage,CheckResult> results = new HashMap<>();

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param fileMessage 出错的消息
     * @param info 出错的消息原因
     * @return 消息和出错的map数据结构
     * @description
     */
    public Map<FileMessage,CheckResult> putErrorCheckResult(FileMessage fileMessage, String info) {
        CheckResult check = results.get(fileMessage);
        if(check == null) {
            check = new CheckResult();
            check.addError(info);
            check.setFileMessage(fileMessage);
            results.put(fileMessage, check);
        }
        return results;
    }


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @return 返回带有消息和消息出错的数据结构List形式
     * @description 获取所有文件的验证信息
     */
    public List<CheckResult> getResults() {
        List<CheckResult> datas = new ArrayList<>();
        if(results.size() > 0) {
            for (Map.Entry<FileMessage, CheckResult> entry : results.entrySet()) {
                datas.add(entry.getValue());
            }
        }
        return datas;
    }

    public void clearResult() {
        results.clear();
    }

}
