package cn.gtmap.realestate.supervise.server.common.impl;

import cn.gtmap.realestate.supervise.model.FileMessage;
import cn.gtmap.realestate.supervise.model.MessageClient;
import cn.gtmap.realestate.supervise.server.common.CheckMessage;
import cn.gtmap.realestate.supervise.server.common.impl.check.*;
import cn.gtmap.realestate.supervise.server.config.Constant;
import cn.gtmap.realestate.supervise.server.dao.SignDao;
import cn.gtmap.realestate.supervise.server.entity.CheckRule;
import cn.gtmap.realestate.supervise.server.entity.Sign;
import cn.gtmap.realestate.supervise.server.model.CheckResult;
import cn.gtmap.realestate.supervise.server.service.RuleFiterService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/4/18
 * @description 验证消息的代理
 */
@Service
public class CheckMessageProxy implements CheckMessage {

    private boolean errorMessage;

    private boolean errorService;

    @Autowired
    BdcDyLxCheck bdcDyLxCheck;

    @Autowired
    BdcZdCheck bdcZdCheck;

    @Autowired
    DjSxCheck djSxCheck;

    @Autowired
    DuplicateContentCheck duplicateContentCheck;

    @Autowired
    DuplicateServiceCheck duplicateServiceCheck;

    @Autowired
    SignatureCheck signatureCheck;

    @Autowired
    SXSGuanXiCheck sxsGuanXiCheck;

    @Autowired
    TuXingTuPuCheck tuXingTuPuCheck;

    @Autowired
    TuXingZuoBiaoCheck tuXingZuoBiaoCheck;

    @Autowired
    UserInfoCheck userInfoCheck;

    @Autowired
    XsdCheck xsdCheck;


    @Autowired
    SignDao signDao;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 检查结果统计工具
     */
    CheckResultManage checkResultManage;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 规则过滤
     */
    @Autowired
    private RuleFiterService ruleInfoService;


    /**
     * 检测工具容器
     */
    List<AbstractCheckMessage> checkMessageList;

    Map<String, AbstractCheckMessage> checkDatas = new HashMap<>();


    /**
     * 初始化验证构造器
     */
    private void initParam() {

        checkDatas.put(bdcDyLxCheck.getCheckCode(), bdcDyLxCheck);
        checkDatas.put(userInfoCheck.getCheckCode(), userInfoCheck);
        checkDatas.put(bdcZdCheck.getCheckCode(), bdcZdCheck);
        checkDatas.put(djSxCheck.getCheckCode(), djSxCheck);
        checkDatas.put(duplicateContentCheck.getCheckCode(), duplicateContentCheck);
        checkDatas.put(duplicateServiceCheck.getCheckCode(), duplicateServiceCheck);
        checkDatas.put(signatureCheck.getCheckCode(), signatureCheck);
        checkDatas.put(sxsGuanXiCheck.getCheckCode(), sxsGuanXiCheck);
        checkDatas.put(tuXingTuPuCheck.getCheckCode(), tuXingTuPuCheck);
        checkDatas.put(tuXingZuoBiaoCheck.getCheckCode(), tuXingZuoBiaoCheck);
        checkDatas.put(xsdCheck.getCheckCode(), xsdCheck);

    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param messages:需要验证的客户端信息
     * @description 验证客户端信息工具
     */
    @Override
    public CheckResultManage checkMessage(MessageClient messages) {

        List<CheckRule> checkMessageRules = ruleInfoService.getRuleInfoByCheck();
        boolean flag = false;
        if (null != checkMessageRules && !checkMessageRules.isEmpty()) {
            checkMessageList = new ArrayList<>();
            for (int i = 0; i < checkMessageRules.size(); i++) {
                String ruleCode = checkMessageRules.get(i).getRulecode();
                if(null!=ruleCode && ruleCode.equals(Constant.DUPLICATE_CONTENT_CHECK)){
                    flag =true;
                }
                checkMessageList.add(checkDatas.get(ruleCode));
            }
            if (!flag) {//没有200102校验规则
                List<FileMessage> fileMessages = messages.getMessageContents();
                insertSign(fileMessages);
            }
            for (AbstractCheckMessage checkMessage : checkMessageList) {

                checkResultManage = checkMessage.checkMessageTemplate(messages);
                /**
                 * 验证消息是否是严重错误，严重错误定义为如果出现此错误没有向下验证的必要消息完全无效的情况
                 */
                if (checkMessage.isMessageError()) {
                    errorMessage = true;
                    return checkResultManage;
                }
                if (checkMessage.isServiceError()) {
                    errorService = true;
                    return checkResultManage;
                }
            }
        } else {
            List<FileMessage> fileMessages = messages.getMessageContents();
            insertSign(fileMessages);
        }
        return checkResultManage;
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 初始化清理
     */
    @Override
    public void initAndClear() {
        /**
         * 重置我们是否发现严重错误的标记
         * 清空错误日志
         */
        errorService = false;
        errorMessage = false;
        /**
         * 如果检查结果没有初始化我们需要添加初始化添加检查结果
         */
        if (null == checkMessageList || checkMessageList.isEmpty()) {
            initParam();
        }

        /**
         * 如果我们检测结果不为0我们需要清除上次存放的结果
         */

        if (null != checkResultManage) {
            List<CheckResult> checkResultList = checkResultManage.getResults();
            if (CollectionUtils.isNotEmpty(checkResultList)) {
                checkResultManage.clearResult();
            }
        }
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @param messages:需要验证的客户端信息
     * @return 返回验证管理对象
     * @description  初始化并返回验证返回对象工具
     */
    @Override
    public CheckResultManage checkMessageTemplate(MessageClient messages) {
        initAndClear();
        return checkMessage(messages);
    }

    public boolean iserrorMessage() {
        return errorMessage;
    }


    public boolean iserrorService() {
        return errorService;
    }


    /**
     * 数字签名表入数据
     *
     * @param fileMessages
     */
    private void insertSign(List<FileMessage> fileMessages) {

        //报文数字签名入库
        for (FileMessage fileMessage : fileMessages) {
            boolean flag = signDao.findBySign(fileMessage.getSign());
            if (!flag) {
                Sign sign = new Sign();
                sign.setSign(fileMessage.getSign());
                signDao.insertSign(sign);
            }
        }
    }
}
