package cn.gtmap.realestate.supervise.server.common.impl;

import cn.gtmap.realestate.supervise.model.MessageClient;
import cn.gtmap.realestate.supervise.server.common.CheckMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/4/18
 * @description 抽象消息实现CheckMessage接口 isGoON属性判断该验证是否有决定全局的作用
 */
@Service
public abstract class AbstractCheckMessage implements CheckMessage {
    private boolean isGoOn;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 检查编码
     */
    private String checkCode;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 消息错误
     */
    private boolean messageError;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 服务端错误
     */
    private boolean serviceError;

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 错误管理类
     */
    @Autowired
    CheckResultManage checkResult;

    /**
     * 初始化该验证是否对后面的验证有影响，如果该验证不通过不进行下面的验证设置为true比如用户验证
     * @param isGoOn
     */
    public AbstractCheckMessage(boolean isGoOn, String checkCode) {
        this.checkCode = checkCode;
        this.isGoOn = isGoOn;
    }

    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 获取验证的结果
     */
    public CheckResultManage getCheckResult() {
        return checkResult;
    }


    /**
     * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
     * @description 初始化参数
     */
    @Override
    public void initAndClear() {
        setMessageError(false);
        setServiceError(false);
    }

    public String getCheckCode() {
        return checkCode;
    }

    public void setCheckCode(String checkCode) {
        this.checkCode = checkCode;
    }

    @Override
    public CheckResultManage checkMessageTemplate(MessageClient messages) {
        /**
         * 清除上次验证出现的false导致这次验证失败，单列的问题；
         */
        if(isMessageError() || isServiceError()) {
            initAndClear();
        }
        return checkMessage(messages);
    }

    public boolean isMessageError() {
        return messageError;
    }

    public void setMessageError(boolean messageError) {
        this.messageError = messageError;
    }

    public boolean isServiceError() {
        return serviceError;
    }

    public void setServiceError(boolean serviceError) {
        this.serviceError = serviceError;
    }
}
