package cn.gtmap.realestate.supervise.server.common;

import cn.gtmap.realestate.supervise.model.MessageClient;
import cn.gtmap.realestate.supervise.server.common.impl.CheckResultManage;
import org.springframework.stereotype.Service;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/4/18
 * @description 验证消息的接口
 */
@Service
public interface CheckMessage {

    /**
     * 需要验证的消息
     * @param messages
     * @return 验证的结果
     */
    CheckResultManage checkMessage(MessageClient messages);

    /**
     * 清除先前生成的数据
     */
    void initAndClear();

    /**
     * 验证消息的模板方法 如果可以支持java8 可以给他一个默认方法相当好
     * 验证消息模板方法是其他方法的组合用于产生验证流程的模板
     */
    CheckResultManage checkMessageTemplate(MessageClient messages) ;

}
