/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.utils.XssFilterUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.lang3.StringUtils;

public class XssAndSqlHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    public XssAndSqlHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public String[] getParameterValues(String name) {
        String[] values = super.getParameterValues(name);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.clearXss(values[i]);
        }
        return encodedValues;
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (value == null) {
            return null;
        }
        return this.clearXss(value);
    }

    public Map getParameterMap() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Map requestMap = super.getParameterMap();
        for (Map.Entry entry : requestMap.entrySet()) {
            if (((String[])entry.getValue()).length == 1) {
                paramMap.put(XssAndSqlHttpServletRequestWrapper.xssEncode((String)entry.getKey()), XssAndSqlHttpServletRequestWrapper.xssEncode(((String[])entry.getValue())[0]));
                continue;
            }
            String[] values = (String[])entry.getValue();
            String value = "";
            for (int i = 0; i < values.length; ++i) {
                value = values[i] + ",";
            }
            value = value.substring(0, value.length() - 1);
            paramMap.put(XssAndSqlHttpServletRequestWrapper.xssEncode((String)entry.getKey()), value);
        }
        return paramMap;
    }

    public Object getAttribute(String name) {
        Object value = super.getAttribute(name);
        if (value != null && value instanceof String) {
            this.clearXss((String)value);
        }
        return value;
    }

    private String clearXss(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        if (XssAndSqlHttpServletRequestWrapper.sqlValidate(value)) {
            throw new RuntimeException("SQL\u6ce8\u5165\u5f02\u5e38");
        }
        return XssFilterUtil.stripXss(value, this.getRequest());
    }

    private static String xssEncode(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        value = value.replaceAll("eval\\((.*)\\)", "");
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll(">", "&gt;");
        value = value.replaceAll("'", "&apos;");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replaceAll("(?i)<script.*?>.*?<script.*?>", "");
        value = value.replaceAll("(?i)<script.*?>.*?</script.*?>", "");
        value = value.replaceAll("(?i)<.*?javascript:.*?>.*?</.*?>", "");
        value = value.replaceAll("(?i)<.*?\\s+on.*?>.*?</.*?>", "");
        return value;
    }

    protected static boolean sqlValidate(String str) {
        String s = str.toLowerCase();
        return str.contains("select") || str.contains("delete") || str.contains("drop") || str.contains("update");
    }
}

