package cn.gtmap.realestate.supervise.utils;

import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @version 1.0 2019-7-11
 * @auther <a href="mailto:xutao@gtmap.cn">xutao</a>
 * @description
 */
public class HeaderFilter implements Filter {

    private String excludedPages;
    private String[] excludedPageArray;

    /**
     * cadreUrl
     */
    private String url = "realestate-supervise";

    /**
     * portalUrl
     */
    private String portalUrl = AppConfig.getProperty("portal.url");

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        excludedPages = filterConfig.getInitParameter("excludedPages");
        if (StringUtils.isNotEmpty(excludedPages)) {
            excludedPageArray = excludedPages.split(",");
        }
        if (null != excludedPageArray && excludedPageArray.length != 0) {
            for (int i = 0; i < excludedPageArray.length; i++) {
                excludedPageArray[i] = StringUtils.trim(excludedPageArray[i]);
            }
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws
        IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest) request;
        HttpServletResponse httpResponse = (HttpServletResponse) response;
        String url = httpRequest.getServletPath();
        boolean isExcludedPage = false;
        if (null != excludedPageArray) {
            for (String page : excludedPageArray) {//判断是否在过滤url之外
                if (validUrl(url, page)) {
                    isExcludedPage = true;
                    break;
                }
            }
        }
        if (isExcludedPage) {//在过滤url之外
            chain.doFilter(request, response);
        } else {
            String referer = httpRequest.getHeader("Referer");
            if (StringUtils.isNotBlank(referer)
                && (referer.contains(this.url) || referer.contains(this.portalUrl))) {
                chain.doFilter(request, response);
            } else {
                httpResponse.sendRedirect(portalUrl + "/loginPage");
            }
        }
    }

    @Override
    public void destroy() {

    }

    /**
     * 验证当前请求是否需要过滤
     *
     * @param url          请求地址
     * @param excludedPage 去除的页面
     * @return 是否需要过滤
     */
    private boolean validUrl(String url, String excludedPage) {
        if (excludedPage.endsWith("/*") || excludedPage.endsWith("/**")) {
            excludedPage = excludedPage.replace("*", "");
        }
        return url.startsWith(excludedPage) || StringUtils.equals(url, excludedPage.substring(0, excludedPage.length() - 1));
    }
}
