/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.utils.AESEncrypter;
import cn.gtmap.realestate.supervise.utils.JedisPoolUtil;
import cn.gtmap.realestate.supervise.utils.TimeUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

public class OpenIdPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIdPool.class);
    private static OpenIdPool openIdPool = null;
    private static final String publickey = "gtmap_exchange_openId";
    private static final int validMinute = 60;
    private static final String REDIS_OPENID = "OPENID";

    private OpenIdPool() {
    }

    public static OpenIdPool getOpenIdPoolInstance() {
        if (null == openIdPool) {
            openIdPool = new OpenIdPool();
        }
        return openIdPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized String getOpenId(String userId) {
        String openId = null;
        if (!StringUtils.isNotBlank((CharSequence)userId)) return openId;
        Jedis jedis = null;
        try {
            Date now = new Date(System.currentTimeMillis());
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmss");
            String strNow = sf.format(now);
            String content = userId + "|" + strNow;
            byte[] bytes = AESEncrypter.encrypt(content, publickey);
            openId = OpenIdPool.byteArrayToHexStr(bytes);
            jedis = JedisPoolUtil.getJedis();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("openId_" + userId, openId);
            map.put("time_" + userId, strNow);
            jedis.hmset(REDIS_OPENID, map);
            if (jedis == null) return openId;
        }
        catch (Exception e) {
            LOGGER.error("\u751f\u6210operId\u5f02\u5e38\uff01{}", (Throwable)e);
            return openId;
        }
        finally {
            if (jedis != null) {
                JedisPoolUtil.closeJedis(jedis);
            }
        }
        JedisPoolUtil.closeJedis(jedis);
        return openId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean validOpenId(String openId) {
        boolean isflag = false;
        if (StringUtils.isNotBlank((CharSequence)openId)) {
            Jedis jedis = null;
            try {
                jedis = JedisPoolUtil.getJedis();
                Map maps = jedis.hgetAll(REDIS_OPENID);
                if (maps.containsValue(openId)) {
                    String timeKey;
                    String time;
                    Date oldDate;
                    boolean isValid;
                    String openIdKey = "";
                    for (Map.Entry entry : maps.entrySet()) {
                        if (!openId.equals(entry.getValue()) || !StringUtils.isBlank((CharSequence)openIdKey)) continue;
                        openIdKey = (String)entry.getKey();
                        break;
                    }
                    if (!(isValid = this.validDate(oldDate = TimeUtils.strToDateTime(time = jedis.hget(REDIS_OPENID, timeKey = openIdKey.replace("openId", "time")))))) {
                        jedis.hdel(REDIS_OPENID, new String[]{timeKey, openIdKey});
                    }
                    isflag = isValid;
                }
            }
            catch (Exception e) {
                LOGGER.error("\u9a8c\u8bc1openId\u662f\u5426\u8fc7\u671f\u5f02\u5e38\uff01{}", (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    JedisPoolUtil.closeJedis(jedis);
                }
            }
        }
        return isflag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeOpenId(String openId) {
        if (StringUtils.isNotBlank((CharSequence)openId)) {
            Jedis jedis = null;
            try {
                jedis = JedisPoolUtil.getJedis();
                Map maps = jedis.hgetAll(REDIS_OPENID);
                if (maps.containsValue(openId)) {
                    String openIdKey = "";
                    for (Map.Entry entry : maps.entrySet()) {
                        if (!openId.equals(entry.getValue()) || !StringUtils.isBlank((CharSequence)openIdKey)) continue;
                        openIdKey = (String)entry.getKey();
                        break;
                    }
                    String timeKey = openIdKey.replace("openId", "time");
                    jedis.hdel(REDIS_OPENID, new String[]{timeKey, openIdKey});
                }
            }
            catch (Exception e) {
                LOGGER.error("\u5220\u9664openId\u5f02\u5e38\uff01{}", (Throwable)e);
            }
            finally {
                if (jedis != null) {
                    JedisPoolUtil.closeJedis(jedis);
                }
            }
        }
    }

    private boolean validDate(Date initDate) {
        Calendar cd = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        cd.setTime(initDate);
        cd.add(12, 60);
        return now.before(cd);
    }

    public static String byteArrayToHexStr(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[byteArray.length * 2];
        for (int j = 0; j < byteArray.length; ++j) {
            int v = byteArray[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

