/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.common.Constant;
import cn.gtmap.realestate.supervise.model.GxRespMdbData;
import cn.gtmap.realestate.supervise.utils.TokenPool;
import cn.gtmap.realestate.supervise.utils.TokenPoolFactory;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=1)
public class CheckMdbTokenAdvice {
    @Pointcut(value="@annotation(cn.gtmap.realestate.supervise.utils.CheckMdbToken)")
    public void anyMethod() {
    }

    @Around(value="anyMethod()")
    public Object doBasicProfiling(ProceedingJoinPoint pjp) {
        GxRespMdbData gxRespMdbData = new GxRespMdbData();
        Object object = null;
        Object[] args = pjp.getArgs();
        if (null != args) {
            String gxDataStr = (String)args[0];
            String token = "";
            if (args.length > 1) {
                token = (String)args[1];
            }
            if (StringUtils.isNotBlank((CharSequence)gxDataStr) && StringUtils.isNotBlank((CharSequence)token)) {
                TokenPool tokenPool = TokenPoolFactory.getTokenPoolInstance();
                boolean isValid = tokenPool.validToken(token);
                if (isValid) {
                    try {
                        object = pjp.proceed();
                    }
                    catch (Throwable throwable) {
                        int code = 3007;
                        gxRespMdbData.setCode(String.valueOf(code));
                        gxRespMdbData.setMsg(Constant.getMsg(code));
                        object = gxRespMdbData;
                    }
                } else {
                    gxRespMdbData.setCode(String.valueOf(2002));
                    gxRespMdbData.setMsg(Constant.getMsg(2002));
                    object = gxRespMdbData;
                }
            } else {
                try {
                    object = pjp.proceed();
                }
                catch (Throwable throwable) {
                    int code = 3007;
                    gxRespMdbData.setCode(String.valueOf(code));
                    gxRespMdbData.setMsg(Constant.getMsg(code));
                    object = gxRespMdbData;
                }
            }
        } else {
            gxRespMdbData.setCode(String.valueOf(2002));
            gxRespMdbData.setMsg(Constant.getMsg(2002));
            object = gxRespMdbData;
        }
        return object;
    }
}

