/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.plugin;

import cn.gtmap.realestate.supervise.aes.SecurityUtil;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class SecurityInterceptor
implements Interceptor {
    SecurityUtil securityUtil;

    public SecurityUtil getSecurityUtil() {
        return this.securityUtil;
    }

    public void setSecurityUtil(SecurityUtil securityUtil) {
        this.securityUtil = securityUtil;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        boolean query = false;
        boolean update = false;
        Object returnValue = null;
        List<String> params = null;
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof MappedStatement) {
                MappedStatement ms = (MappedStatement)arg;
                SqlCommandType sqlCommandType = ms.getSqlCommandType();
                if (sqlCommandType == SqlCommandType.INSERT || sqlCommandType == SqlCommandType.UPDATE) {
                    update = true;
                    continue;
                }
                if (sqlCommandType != SqlCommandType.SELECT) continue;
                if (arg instanceof MappedStatement) {
                    MappedStatement map = (MappedStatement)arg;
                    params = this.securityUtil.getAllAnnoationInfo(((ResultMap)map.getResultMaps().get(0)).getType());
                }
                query = true;
                continue;
            }
            if (update) {
                if (arg instanceof Map) {
                    Map maps = (Map)arg;
                    if (maps.containsKey("record")) {
                        Object object = maps.get("record");
                        this.setProperty(object);
                    }
                } else {
                    this.setProperty(arg);
                }
                update = false;
            }
            if (query) {
                if (params != null && params.size() > 0 && arg instanceof Map) {
                    this.setQueryMap((Map)arg, params);
                }
                query = false;
            }
            if ((returnValue = invocation.proceed()) == null || !(returnValue instanceof ArrayList)) continue;
            ArrayList list = (ArrayList)returnValue;
            for (Object val : list) {
                this.securityUtil.DecryptField(val);
            }
            break;
        }
        return returnValue;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    public void setProperty(Object o) throws InvocationTargetException, IllegalAccessException, ParseException {
        this.securityUtil.EncryptField(o);
    }

    public void setQueryMap(Map map, List<String> params) {
        for (String param : map.keySet()) {
            if (!params.contains(param)) continue;
            map.put(param, this.securityUtil.encrypt(map.get(param).toString()));
        }
    }
}

