package cn.gtmap.realestate.supervise.utils;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * 2018/6/21.
 * 单例线程池
 */
public class ThreadPoolUtils {


    private static ThreadPoolUtils threadPoolUtils = new ThreadPoolUtils();

    // 线程池维护线程的最少数量
    private static final int SIZE_CORE_POOL = 15;

    // 线程池维护线程的最大数量
    private static final int SIZE_MAX_POOL = 15;

    /**
     * 线程池
     *
     * @param corePoolSize - 池中所保存的线程数，包括空闲线程。
     * @param maximumPoolSize - 池中允许的最大线程数。
     * @param keepAliveTime - 当线程数大于核心时，此为终止前多余的空闲线程等待新任务的最长时间。
     * @param unit - keepAliveTime 参数的时间单位。
     * @param workQueue - 执行前用于保持任务的队列。此队列仅由保持 execute 方法提交的 Runnable 任务。
     * @param handler - 由于超出线程范围和队列容量而使执行被阻塞时所使用的处理程序。
     */
    // 实质就是newFixedThreadPool 创建一个定长线程池，可控制线程最大并发数，超出的线程会在队列中等待
    private final ThreadPoolExecutor mThreadPool = new ThreadPoolExecutor(SIZE_CORE_POOL, SIZE_MAX_POOL, 0L,
            TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());


    /**
     * 将构造方法访问修饰符设为私有，禁止任意实例化。
     */
    private ThreadPoolUtils() {

    }

    /**
     * 线程池单例创建方法
     *
     * @return
     */
    public static ThreadPoolUtils getInstance() {
        return threadPoolUtils;
    }


    /**
     * 向线程池添加任务
     *
     * @param runnable
     */
    public void addTask(Runnable runnable) {
        mThreadPool.execute(runnable);
    }


    /*
     * 关闭线程池，不在接受新的任务，会把已接受的任务执行玩
     */
    public void shutdown() {
        mThreadPool.shutdown();
    }

}
