package cn.gtmap.realestate.supervise.model;

import java.util.List;
import java.util.Map;

/**
 * @author <a href="mailto:gaofeng@gtmap.cn">gaofeng</a>
 * @version 1.0, 2017/10/10
 * @description 报文头、报文体封装实体类
 */
public class GxReqListData {

    /**
     * 报文头
     */
    private Map<String, Object> head;

    /**
     * 报文体
     */
    private String data;

    public Map<String, Object> getHead() {
        return head;
    }

    public void setHead(Map<String, Object> head) {
        this.head = head;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getXzqdm() {
        return getValue("xzqdm", String.class);
    }

    public String getToken() {
        return getValue("token", String.class);
    }

    public int getSize() {
        return getValue("size", Integer.class);
    }

    public int getPage() {
        return getValue("page", Integer.class);
    }

    public String getCxjgbs() {
        return getValue("cxjgbs", String.class);
    }


    public String getXz() {
        return getValue("xz", String.class);
    }

    public String getCxdw() {
        return getValue("cxdw", String.class);
    }

    public String getCxfw() {
        return getValue("cxfw", String.class);
    }

    public String getCxlb() {
        return getValue("cxlb", String.class);
    }

    private <T> T getValue(String key, Class<T> clazz) {
        Map head = this.head;
        if (null != head) {
            if (head.containsKey(key)) {
                return clazz.cast(head.get(key));
            }
        }
        return null;
    }
}
