package cn.gtmap.realestate.supervise.entity;

import javax.persistence.Id;
import javax.persistence.Table;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * @author szh
 * @version 1.0, 2019/1/4
 * @description 工业用地城镇用地抵押季度报表
 */
@Table(name = "TJ_GYCZZZYDDYJD")
public class TjGyczzzyddyjd {
    @Id
    /**
     * 年份
     */
    private String tjn;
    /**
     * 季度
     */
    private String tjjd;
    /**
     * 填报人
     */
    private String tbr;
    /**
     * 填报时间
     */
    private Date tbsj;
    /**
     * 一级行政区
     */
    private String yjxzq;
    /**
     * 二级行政区
     */
    private String ejxzq;
    /**
     * 工业抵押件数
     */
    private String gyjs;
    /**
     * 工业土地抵押面积
     */
    private String gytddymj;
    /**
     * 工业在建建筑物、构筑物抵押面积
     */
    private String gyzjjzwgjwdymj;
    /**
     * 工业已竣工建筑物、构筑物抵押面积
     */
    private String gyyjgjzwgjwdymj;
    /**
     * 工业抵押金额
     */
    private String gydyjr;
    /**
     * 住宅抵押件数
     */
    private String zzjs;
    /**
     * 住宅在建建筑物抵押面积
     */
    private String zzzjjzwgjwdymj;
    /**
     * 住宅已竣工建筑物、构筑物抵押面积
     */
    private String zzyjgjzwgjwdymj;
    /**
     * 住宅抵押金额
     */
    private String zzdyjr;
    /**
     * 填报时间
     */
    private String sbsj;

    public String getTjn() {
        return tjn;
    }

    public void setTjn(String tjn) {
        this.tjn = tjn;
    }

    public String getTjjd() {
        return tjjd;
    }

    public void setTjjd(String tjjd) {
        this.tjjd = tjjd;
    }

    public String getTbr() {
        return tbr;
    }

    public void setTbr(String tbr) {
        this.tbr = tbr;
    }

    public Date getTbsj() {
        return tbsj;
    }

    public void setTbsj(Date tbsj) {
        this.tbsj = tbsj;
    }

    public String getYjxzq() {
        return yjxzq;
    }

    public void setYjxzq(String yjxzq) {
        this.yjxzq = yjxzq;
    }

    public String getEjxzq() {
        return ejxzq;
    }

    public void setEjxzq(String ejxzq) {
        this.ejxzq = ejxzq;
    }

    public String getGyjs() {
        return gyjs;
    }

    public void setGyjs(String gyjs) {
        this.gyjs = gyjs;
    }

    public String getGytddymj() {
        return gytddymj;
    }

    public void setGytddymj(String gytddymj) {
        this.gytddymj = gytddymj;
    }

    public String getGyzjjzwgjwdymj() {
        return gyzjjzwgjwdymj;
    }

    public void setGyzjjzwgjwdymj(String gyzjjzwgjwdymj) {
        this.gyzjjzwgjwdymj = gyzjjzwgjwdymj;
    }

    public String getGyyjgjzwgjwdymj() {
        return gyyjgjzwgjwdymj;
    }

    public void setGyyjgjzwgjwdymj(String gyyjgjzwgjwdymj) {
        this.gyyjgjzwgjwdymj = gyyjgjzwgjwdymj;
    }

    public String getGydyjr() {
        return gydyjr;
    }

    public void setGydyjr(String gydyjr) {
        this.gydyjr = gydyjr;
    }

    public String getZzjs() {
        return zzjs;
    }

    public void setZzjs(String zzjs) {
        this.zzjs = zzjs;
    }

    public String getZzzjjzwgjwdymj() {
        return zzzjjzwgjwdymj;
    }

    public void setZzzjjzwgjwdymj(String zzzjjzwgjwdymj) {
        this.zzzjjzwgjwdymj = zzzjjzwgjwdymj;
    }

    public String getZzyjgjzwgjwdymj() {
        return zzyjgjzwgjwdymj;
    }

    public void setZzyjgjzwgjwdymj(String zzyjgjzwgjwdymj) {
        this.zzyjgjzwgjwdymj = zzyjgjzwgjwdymj;
    }

    public String getZzdyjr() {
        return zzdyjr;
    }

    public void setZzdyjr(String zzdyjr) {
        this.zzdyjr = zzdyjr;
    }

    public String getSbsj() {
        if (null != tbsj) {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sf.format(tbsj);
        }
        return sbsj;
    }
}
