/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.rpc.client.RPCServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebServiceUtil {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceUtil.class);
    private static ConfigurationContext configurationContext;

    public static String sendRequest(String url, String nameSpace, String methodName, Map<String, String> params) {
        RPCServiceClient serviceClient = null;
        String res = "";
        try {
            serviceClient = new RPCServiceClient(configurationContext, null);
            Options options = serviceClient.getOptions();
            EndpointReference targetEPR = new EndpointReference(url);
            options.setTo(targetEPR);
            options.setExceptionToBeThrownOnSOAPFault(false);
            options.setManageSession(true);
            options.setProperty("REUSE_HTTP_CLIENT", (Object)true);
            options.setProperty("SO_TIMEOUT", (Object)120000);
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace(nameSpace, methodName);
            OMElement data = fac.createOMElement(methodName, omNs);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                QName qname = new QName(entry.getKey());
                OMElement inner = fac.createOMElement(qname);
                inner.setText(entry.getValue());
                data.addChild((OMNode)inner);
            }
            OMElement object = serviceClient.sendReceive(data);
            res = object.getFirstElement().getText();
            serviceClient.cleanupTransport();
        }
        catch (Exception e) {
            logger.error("----------\u8c03\u7528WebServiceUtil.webService\u670d\u52a1\u5f02\u5e38,\u5f02\u5e38\u5730\u5740\uff1a{}\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}>>>>------", (Object)url, (Object)e);
        }
        return res;
    }

    public static String axis2sendRequest(String url, String nameSpace, String methodName, String[] vals, String[] keys) {
        String res = "";
        try {
            ServiceClient sender = new ServiceClient(configurationContext, null);
            EndpointReference endpointReference = new EndpointReference(url);
            Options options = new Options();
            options.setTo(endpointReference);
            options.setProperty("SO_TIMEOUT", (Object)120000);
            sender.setOptions(options);
            OMFactory fac = OMAbstractFactory.getOMFactory();
            OMNamespace omNs = fac.createOMNamespace(nameSpace, methodName);
            OMElement data = fac.createOMElement(methodName, omNs);
            for (int i = 0; i < keys.length; ++i) {
                QName qname = new QName(keys[i]);
                OMElement inner = fac.createOMElement(qname);
                inner.setText(vals[i]);
                data.addChild((OMNode)inner);
            }
            OMElement result = sender.sendReceive(data);
            res = result.getFirstElement().getText();
        }
        catch (AxisFault ex) {
            ex.printStackTrace();
        }
        return res;
    }

    static {
        try {
            configurationContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
        }
        catch (AxisFault axisFault) {
            axisFault.printStackTrace();
        }
    }
}

