package cn.gtmap.realestate.supervise.utils;

import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.HashMap;
import java.util.Map;

/**
 * @param
 * @author <a href="mailto:liuqiang@gtmap.cn">liuqiang</a>
 * @return
 * @description 2021/2/22 方法参考TokenPool,为了方便只修改了入参的名字以及方法的名字,具体的变量名没修改
 */
public class YzmTokenPool {
    //token对象（单例）
    private static YzmTokenPool yzmTokenPool = null;
    //token集合
    private List<TokenEntry> yzmTokenPools = new ArrayList<TokenEntry>();
    //token加密的公钥
    private final static String publickey = "gtmap_wechat";
    //默认1天的有效期
    private final static String validMinute = AppConfig.getProperty("valid.Minute") == null ? "5" : AppConfig.getProperty("valid.Minute");

    //redis 表名
    private final static String REDIS_TOKEN = "TOKEN";

    private static final Logger LOGGER = LoggerFactory.getLogger(TokenPool.class);

    private YzmTokenPool() {
    }

    public static YzmTokenPool getTokenPoolInstance() {
        if (null == yzmTokenPool) {
            yzmTokenPool = new YzmTokenPool();
        }
        return yzmTokenPool;
    }

    /**
     * @param key(手机号加验证码)
     * @return
     * @description 2021/2/22 根据提供的手机号加验证码加密生成token并返回
     * @author <a href="mailto:liuqiang@gtmap.cn">liuqiang</a>
     */
    public synchronized String getToken(String key) {
        String token = null;
        if (StringUtils.isNotBlank(key)) {
            token = validUserHasToken(key);
            if (StringUtils.isNotBlank(token)) {
                return token;
            }
            Date now = new Date(System.currentTimeMillis());
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmss");
            String strNow = sf.format(now);
            String content = key + "|" + strNow;
            byte[] bytes = AESEncrypter.encrypt(content, publickey);
            token = byteArrayToHexStr(bytes);
            Jedis jedis = JedisPoolUtil.getJedis();
            Map<String, String> map = new HashMap<>();
            map.put("token_" + key, token);
            map.put("time_" + key, strNow);
            map.put("userId_" + key, key);
            jedis.hmset(REDIS_TOKEN, map);
            jedis.close();
        }
        return token;
    }


    /**
     * 验证token是否过期
     *
     * @param token
     * @return
     */
    public synchronized boolean validToken(String token) {
        boolean isflag = false;
        if (StringUtils.isNotBlank(token)) {
            Jedis jedis = JedisPoolUtil.getJedis();
            Map<String, String> maps = jedis.hgetAll(REDIS_TOKEN);
            if (maps.containsValue(token)) {
                String tokenKey = "";
                String timeKey = "";
                String userIdKey = "";
                for (Map.Entry<String, String> entry : maps.entrySet()) {
                    if (token.equals(entry.getValue()) && StringUtils.isBlank(tokenKey)) {
                        tokenKey = entry.getKey();
                        break;
                    }
                }
                timeKey = tokenKey.replace("token", "time");
                userIdKey = tokenKey.replace("token", "userId");
//                String time = jedis.hget(REDIS_TOKEN, timeKey);
                String time = formatTime(timeKey);
                Date oldDate = TimeUtils.strToDateTime(time);
                boolean isValid = validDate(oldDate);
                if (!isValid) {
                    jedis.hdel(REDIS_TOKEN, new String[]{userIdKey, timeKey, tokenKey});
                }
                isflag = isValid;
            }
            jedis.close();
        }
        return isflag;
    }

    /**
     * 验证是否过期
     *
     * @param initDate
     * @return
     */
    private boolean validDate(Date initDate) {
        int min = 5;
        if (StringUtils.isNotBlank(validMinute)) {
            min = Integer.parseInt(validMinute);
        }
        Calendar cd = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        cd.setTime(initDate);
        cd.add(Calendar.MINUTE, min);
        if (now.before(cd)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * @param key(手机号加验证码)
     * @return
     * @description 2021/2/22 验证验证码是否存在有效的token
     * @author <a href="mailto:liuqiang@gtmap.cn">liuqiang</a>
     */
    public String validUserHasToken(String key) {
        String token = null;
        if (StringUtils.isNotBlank(key)) {
            Jedis jedis = JedisPoolUtil.getJedis();
            String userIdKey = "userId_" + key;
            String timeKey = "time_" + key;
            String tokenKey = "token_" + key;
            String userIdStr = jedis.hget(REDIS_TOKEN, userIdKey);
            if (StringUtils.isNotEmpty(userIdStr)) {
                if (StringUtils.equals(key, userIdStr)) {
                    String time = jedis.hget(REDIS_TOKEN, timeKey);
                    if (StringUtils.isNotEmpty(time)) {
                        Date oldDate = TimeUtils.strToDateTime(time);
                        boolean isValid = validDate(oldDate);
                        if (isValid) {
                            token = jedis.hget(REDIS_TOKEN, tokenKey);
                            Map<String, String> map = new HashMap<>();
                            map.put(timeKey, TimeUtils.dateToStr(new Date(System.currentTimeMillis())));
                            jedis.hmset(REDIS_TOKEN, map);//刷新生命周期
                        } else {
                            jedis.hdel(REDIS_TOKEN, new String[]{userIdKey, timeKey, tokenKey});
                        }
                    }
                }
            }
            jedis.close();
        }
        return token;
    }

    public static String byteArrayToHexStr(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[byteArray.length * 2];
        for (int j = 0; j < byteArray.length; j++) {
            int v = byteArray[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0x0F];
        }
        return new String(hexChars);
    }

    public class TokenEntry {
        String token;
        Date initDate;
        String initUser;

        public String getToken() {
            return token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public Date getInitDate() {
            return initDate;
        }

        public void setInitDate(Date initDate) {
            this.initDate = initDate;
        }

        public String getInitUser() {
            return initUser;
        }

        public void setInitUser(String initUser) {
            this.initUser = initUser;
        }
    }

    /**
     * @param token 安全令牌
     * @return username 用户名称
     * @description 根据token获取用户名称
     * @author <a href="mailto:liuqiang@gtmap.cn">liuqiang</a>
     */
    public static String getUsernameByToken(String token) {
        String username = "";
        if (StringUtils.isNotBlank(token)) {
            Jedis jedis = JedisPoolUtil.getJedis();
            try {
                Map<String, String> maps = jedis.hgetAll(REDIS_TOKEN);
                if (maps.containsValue(token)) {
                    String tokenKey = "";
                    for (Map.Entry<String, String> entry : maps.entrySet()) {
                        if (token.equals(entry.getValue()) && StringUtils.isBlank(tokenKey)) {
                            tokenKey = entry.getKey();
                            break;
                        }
                    }
                    if (StringUtils.isNotBlank(tokenKey)) {
                        username = tokenKey.replace("token_", "");
                    }
                }
            } catch (Exception e) {
                LOGGER.error("");
            } finally {
                jedis.close();
            }
        }
        return username;
    }

    //去除时间戳
    public static String formatTime(String time) {
        if (StringUtils.isNoneBlank(time)) {
            return time.split("_")[1].substring(0, 13);
        } else {
            return null;
        }
    }

}
