package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.estateplat.core.ex.AppException;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.dom4j.*;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import java.io.*;
import java.util.*;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/3/23
 * @description xml工具封装
 */
public class XmlUtil {

    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtil.class);

    /**
     * @param fileContent   需要抽取的字符串
     * @param parentElement 父节点名称
     * @return
     * @throws
     * @description 获取xml特定节点的信息 对节点的样式有比较严格的规范
     * 获取的样板如下
     * <head>
     * <name>person</name>
     * <sex>sex</sex>
     * </head>
     * 可以获取head并返回包含key分别为name和sex value分别为person和sex的map
     */
    public static Map<String, String> getParamValueByElement(String fileContent, String parentElement) throws DocumentException {
//        SAXReader reader = new SAXReader();
        Document doc;
        doc = DocumentHelper.parseText(fileContent);

        String name = null;
        String value = null;
        Map<String, String> data = new HashMap<String, String>();
        Element root = doc.getRootElement();
        Element head = root.element(parentElement);
        List<Element> list = head.elements();
        for (Element e : list) {
            name = e.getName().trim();
            value = e.getText().trim();
            data.put(name, value);
        }

        return data;
    }

    /**
     * @param xmlStr 需要验证的xml字符串
     * @param xsdStr 验证xml的xsd字符串
     * @return 包含验证结果的对象
     */
    public static XmlValidateResult checkXmlByXsd(String xmlStr, String xsdStr) {

        // 创建返回值类，默认为失败
        XmlValidateResult vs = new XmlValidateResult();

        if (xmlStr == null || xsdStr == null) {
            return vs;
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
// 包装待验证的xml字符串为Reader
        Reader xmlReader = new BufferedReader(new StringReader(xmlStr));
// 保障Schema xsd字符串为Reader
        Reader xsdReader = new BufferedReader(new StringReader(xsdStr));
        try {
// 构造Schema Source
            Source xsdSource = new StreamSource(xsdReader);
// 解析作为Schema的指定源并以Schema形式返回它
            Schema schema = factory.newSchema(xsdSource);
// 根据Schema检查xml文档的处理器,创建此 Schema的新 validator
            Validator validator = schema.newValidator();
// 构造待验证xml Source
            Source xmlSource = new StreamSource(xmlReader);
// 执行验证
            validator.validate(xmlSource);
// 设置验证通过
            vs.setValidated(true);
            return vs;
        } catch (SAXException ex) {
// 设置验证失败
            vs.setValidated(false);
// 设置验证失败信息
            vs.setErrorMsg(ex.getMessage());
            return vs;
        } catch (IOException e) {
// 设置验证失败
            vs.setValidated(false);
// 设置验证失败信息
            vs.setErrorMsg(e.getMessage());
            return vs;
        }
    }


    public static String getXmlByRemoveElement(String fileContent, List<String> elementNames) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document doc;
        doc = DocumentHelper.parseText(fileContent);
        Map<String, String> data = new HashMap<String, String>();
        Element root = doc.getRootElement();
        Element head = root.element("Head");
        List<Element> list = head.elements();
        for (Element e : list) {
            if (elementNames.contains(e.getName())) {
                e.getParent().remove(e);
            }
        }
        return root.asXML();
    }

    public static String addParamValueByElement(String xmlContent, String sign) throws DocumentException {
        SAXReader reader = new SAXReader();
        Document doc;
        doc = DocumentHelper.parseText(xmlContent);
        Map<String, String> data = new HashMap<String, String>();
        Element root = doc.getRootElement();
        Element head = root.element("Head");
        Element e = head.addElement("DigitalSign");
        e.setText(sign);
        System.out.println(root.asXML());
        return root.asXML();
    }

    public static String getTextByXpath(String xpath, String xml) {
        try {
            Document document = DocumentHelper.parseText(xml);
            Node destNode = document.selectSingleNode(xpath);
            if (destNode == null) {
                LOGGER.info("XML文档中找不到匹配的路径" + xpath + ",无法解析文档.");
                return "";
            }
            return destNode.getText();
        } catch (Exception e) {
            LOGGER.info("XmlUtil, " + e.getMessage(), e);
        }
        return "";
    }

    /**
     * @param element
     * @return void
     * @description xml转json
     */
    public static JSONObject dom4j2Json(Element element) {

        JSONObject json = new JSONObject();
        //如果是属性
        for (Object o : element.attributes()) {
            Attribute attr = (Attribute) o;
            if (!isEmpty(attr.getValue())) {
                json.put("@" + attr.getName(), attr.getValue());
            }
        }
        List<Element> chdEl = element.elements();
        if (chdEl.isEmpty() && !isEmpty(element.getText())) {//如果没有子元素,只有一个值
            json.put(element.getName(), element.getText());
        }

        for (Element e : chdEl) {//有子元素
            if (!e.elements().isEmpty()) {//子元素也有子元素
                JSONObject chdjson = dom4j2Json(e);
                Object o = json.get(e.getName());
                if (o != null) {
                    JSONArray jsona = null;
                    if (o instanceof JSONObject) {//如果此元素已存在,则转为jsonArray
                        JSONObject jsono = (JSONObject) o;
                        json.remove(e.getName());
                        jsona = new JSONArray();
                        jsona.add(jsono);
                        jsona.add(chdjson);
                    }
                    if (o instanceof JSONArray) {
                        jsona = (JSONArray) o;
                        jsona.add(chdjson);
                    }
                    json.put(e.getName(), jsona);
                } else {
                    if (!chdjson.isEmpty()) {
                        json.put(e.getName(), chdjson);
                    }
                }


            } else {//子元素没有子元素
                for (Object o : element.attributes()) {
                    Attribute attr = (Attribute) o;
                    if (!isEmpty(attr.getValue())) {
                        json.put("@" + attr.getName(), attr.getValue());
                    }
                }
                if (!e.getText().isEmpty()) {
                    json.put(e.getName(), e.getText());
                } else {
                    json.put(e.getName(), "");
                }
            }
        }
        return json;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().isEmpty() || "null".equals(str);
    }

    /**
     * @return 配置内容
     * @author <a href="mailto:wudechuan@gtmap.cn">wudechuan</a>
     * @description 读取xml获取电子证照下发区县对照
     */
    public static Map<String, List<String>> getDzzzXfQxConfig() {
        Map<String, List<String>> configMap = new HashMap<>();
        SAXReader sr = new SAXReader();
        Document document = null;
        try {
            InputStream fis = XmlUtil.class.getClassLoader().getResourceAsStream("conf/dzzz_qx.xml");
            document = sr.read(fis);
        } catch (DocumentException e) {
            e.printStackTrace();
        }
        if (document == null) {
            throw new AppException("读取报文补偿xml配置文件出错，请联系管理员！");
        }
        Element root = document.getRootElement();
        Iterator iterator = root.elementIterator();
        while (iterator.hasNext()) {
            Element element = (Element) iterator.next();
            String quXian = element.attribute("id").getValue();
            List<String> list = new ArrayList<>();
            List elements = element.elements("zhdm");
            if (CollectionUtils.isNotEmpty(elements)) {
                for (Object ywbmElement : elements) {
                    Element ywbmElement1 = (Element) ywbmElement;
                    list.add(ywbmElement1.getTextTrim());
                }
            }
            configMap.put(quXian, list);
        }
        return configMap;
    }

    public static class XmlValidateResult {

        // 是否通过验证
        private boolean validated;

        // 错误信息
        private String errorMsg;

        // 构造函数，默认为不通过，错误原因为空字符串
        public XmlValidateResult() {
            validated = false;
            errorMsg = "";
        }

        public String getErrorMsg() {
            return errorMsg;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public boolean isValidated() {
            return validated;
        }

        public void setValidated(boolean validated) {
            this.validated = validated;
        }

    }
}
