package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.common.Constant;
import cn.gtmap.realestate.supervise.model.GxRespMdbData;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;

/**
 * @author hqz
 * @version 1.0, 2017/7/10
 * @description 访问接口校验AOP
 */
@Aspect
@Order(1)
public class CheckMdbTokenAdvice {
    @Pointcut("@annotation(cn.gtmap.realestate.supervise.utils.CheckMdbToken)")
    public void anyMethod(){
    }

    @Around("anyMethod()")
    public Object doBasicProfiling(ProceedingJoinPoint pjp) {
        GxRespMdbData gxRespMdbData = new GxRespMdbData();
        Object object = null;
        Object[] args = pjp.getArgs();//传入的参数
        if(null != args){
            String gxDataStr = (String) args[0];
            String token = "";
            if(args.length > 1){
                token = (String) args[1];
            }
            if(StringUtils.isNotBlank(gxDataStr) && StringUtils.isNotBlank(token)) {
                TokenPool tokenPool = TokenPoolFactory.getTokenPoolInstance();
                boolean isValid = tokenPool.validToken(token);
                if (isValid) {
                    try {
                        object = pjp.proceed();
                    } catch (Throwable throwable) {
                        int code = Constant.XTYC;
                        gxRespMdbData.setCode(String.valueOf(code));
                        gxRespMdbData.setMsg(Constant.getMsg(code));
                        object = gxRespMdbData;
                    }
                } else {
                    gxRespMdbData.setCode(String.valueOf(Constant.TOKEN));
                    gxRespMdbData.setMsg(Constant.getMsg(Constant.TOKEN));
                    object = gxRespMdbData;
                }
            } else {
                try {
                    object = pjp.proceed();
                } catch (Throwable throwable) {
                    int code = Constant.XTYC;
                    gxRespMdbData.setCode(String.valueOf(code));
                    gxRespMdbData.setMsg(Constant.getMsg(code));
                    object = gxRespMdbData;
                }
            }
        }else{
            gxRespMdbData.setCode(String.valueOf(Constant.TOKEN));
            gxRespMdbData.setMsg(Constant.getMsg(Constant.TOKEN));
            object = gxRespMdbData;
        }

        return object;

    }
}
