package cn.gtmap.realestate.supervise.service;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.entity.XtRegion;

import java.lang.String;
import java.util.List;

/**
 * @author hqz
 * @version 1.0, 2017/6/8
 * @description 验证信息类
 */
public interface SecuritySSOHandleService {

    public UserAuthDTO validUser(String uuid);

    public boolean validResource(String url, String uuid, String groupNo);

    public XtRegion getXzqhOne(String qhdm);

    public List<XtRegion> getXzqhNext(String qhdm);

    public List<XtRegion> getCurruserRegion(String userId);

    public List<XtGroup> getCurruserGroup(String userId);

    List<XtRegion> getRegion(String str);

    //获取当前用户最大的行政区
    XtRegion getMaxRegion(String userId);

    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param qhdm 区划代码
     * @param level 区划级别
     * @return
     * @description 获取对应级别的行政区划列表信息
     */
    public List<XtRegion> getLevelXzqh(String qhdm, String level);

}
