package cn.gtmap.realestate.supervise.model.yw_encrypt;

import cn.gtmap.realestate.supervise.common.FieldSign;
import com.jmj.FMException;
import com.jmj.FmBaseApi;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;

/**
 * @author: <a href="mailto:chenyongqiang@gtmap.cn">chenyongqiang</a>
 * @descriptions:
 */
public class YwApi {
    private final static Logger logger = LoggerFactory.getLogger(YwApi.class);
    private final static int SM4_ENCRYPT_MODEL = 1;
    private final static int SM4_DECRYPT_MODEL = 2;
    private static FmBaseApi fmapi;
    private static String password = "12345678";
    private static int KEY_NUM = 1;
    private static int FME_OK = (byte) 0x000;
    public final static String prefix = "pamtgms";
    public final static String CONCAT_SYMBOL_EQ = "=";
    public final static String CONCAT_SYMBOL_AND = "&";
    /**
     * 字符串逗号分隔符
     */
    public static final String SPLIT_STR_COMMA = ",";

    public static void getConnect() {
        if (null == fmapi) {
            fmapi = FmBaseApi.getInstance();
        }
        try {
            //logger.error("fmapi 密码：" + password + " 开始连接。。。");
            fmapi.FM_CPC_OpenDevice(password.getBytes());
            //System.out.println("fmapi 连接成功。。。");
        } catch (FMException e) {
            e.printStackTrace();
            throw new RuntimeException("渔翁加密机连接异常");
        }
    }

    public static void close() {
        if (null == fmapi) {
            fmapi = FmBaseApi.getInstance();
        }
        fmapi.FM_CPC_CloseDevice();
        //System.out.println("fmapi 关闭连接。。。");
    }

    /**
     * SM4加密
     *
     * @param sm4Indata
     * @return
     */
    public static String sm4EncryptHexStr(String sm4Indata) {
        StringBuilder ret_sm4Indata = new StringBuilder("");
        try {
            if (null != sm4Indata && !sm4Indata.startsWith(prefix)) {
                String[] sm4IndataArr = StringUtils.split(sm4Indata, SPLIT_STR_COMMA);
                if (sm4IndataArr.length > 0) {
                    for (String sm4IndataTemp : sm4IndataArr) {
                        if (StringUtils.length(ret_sm4Indata) > 3500) {
                            break;
                        }
                        byte[] inData = padding(sm4IndataTemp.getBytes("UTF-8"), SM4_ENCRYPT_MODEL);
                        byte[] endata = new byte[inData.length];
                        int[] oulen = new int[1];

                        int rv = fmapi.FM_CPC_Encrypt(KEY_NUM,
                                fmapi.FM_ALG_SM4, fmapi.FM_ALGMODE_ECB,
                                inData, inData.length,
                                endata, oulen, null,
                                0, null, 0);
                        if (rv != FME_OK) {
                            logger.error(sm4Indata + "SM4加密失败！ FM_CPC_Encrypt 加密返回状态码：" + rv);
                            throw new RuntimeException(sm4Indata + "SM4加密失败！ FM_CPC_Encrypt 加密返回状态码：" + rv);
                        } else {
                            String xx = prefix + Hex.encodeHexString(endata);
                            if (StringUtils.isNotBlank(ret_sm4Indata)) {
                                ret_sm4Indata = ret_sm4Indata.append(SPLIT_STR_COMMA).append(xx);
                            } else {
                                ret_sm4Indata = ret_sm4Indata.append(xx);
                            }
                        }
                    }
                }
            } else {
                return sm4Indata;
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return ret_sm4Indata.toString();
    }


    /**
     * SM4解密
     *
     * @param sm4HexData
     * @return
     */
    public static String sm4DecryptHexStr(String sm4HexData) {
        StringBuilder ret_sm4HexData = new StringBuilder("");
        try {
            if (StringUtils.isNotBlank(sm4HexData) && sm4HexData.startsWith(prefix)) {
                String[] sm4HexDataArr = StringUtils.split(sm4HexData, SPLIT_STR_COMMA);
                if (sm4HexDataArr.length > 0) {
                    for (String sm4HexDataTemp : sm4HexDataArr) {
                        //byte[] inData = padding(Hex.decodeHex(sm4HexData.substring(prefix.length()).toCharArray()),SM4_DECRYPT_MODEL);
                        byte[] inData = Hex.decodeHex(sm4HexDataTemp.substring(prefix.length()).toCharArray());
                        byte[] outdata = new byte[inData.length];
                        int[] oulen = new int[1];

                        int rv = fmapi.FM_CPC_Decrypt(KEY_NUM,
                                fmapi.FM_ALG_SM4, fmapi.FM_ALGMODE_ECB,
                                inData, inData.length,
                                outdata, oulen, null, 0, null, 0);
                        if (rv != FME_OK) {
                            logger.error(sm4HexData + "SM4解密失败！ FM_CPC_Decrypt 解密返回状态码：" + rv);
                            throw new RuntimeException(sm4HexData + "SM4解密失败！ FM_CPC_Encrypt 加密返回状态码：" + rv);
                        } else {
                            byte[] res = padding(outdata, SM4_DECRYPT_MODEL);
                            String ret = new String(res, "UTF-8");
                            if (StringUtils.isNotBlank(ret_sm4HexData)) {
                                ret_sm4HexData = ret_sm4HexData.append(SPLIT_STR_COMMA).append(ret);
                            } else {
                                ret_sm4HexData = ret_sm4HexData.append(ret);
                            }
                            //return new String(inData,"UTF-8");
                        }
                    }
                }
            } else {
                return sm4HexData;
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (DecoderException e) {
            e.printStackTrace();
        }
        return ret_sm4HexData.toString();
    }

    /**
     * SM4加密
     *
     * @param sm4Indata
     * @return
     */
    public static String sm4EncryptBase64Str(String sm4Indata) {
        try {
            if (null != sm4Indata && !sm4Indata.startsWith(prefix)) {
                byte[] inData = padding(sm4Indata.getBytes("UTF-8"), SM4_ENCRYPT_MODEL);
                byte[] endata = new byte[inData.length];
                int[] oulen = new int[1];

                int rv = fmapi.FM_CPC_Encrypt(KEY_NUM,
                        fmapi.FM_ALG_SM4, fmapi.FM_ALGMODE_ECB,
                        inData, inData.length,
                        endata, oulen, null,
                        0, null, 0);
                if (rv != FME_OK) {
                    logger.error(sm4Indata + "SM4加密失败！ FM_CPC_Encrypt 加密返回状态码：" + rv);
                    throw new RuntimeException(sm4Indata + "SM4加密失败！ FM_CPC_Encrypt 加密返回状态码：" + rv);
                } else {
                    return prefix + Base64.encodeBase64String(endata);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return sm4Indata;
    }

    /**
     * SM4解密
     *
     * @param sm4Data
     * @return
     */
    public static String sm4DecryptBase64tr(String sm4Data) {
        try {
            if (StringUtils.isNotBlank(sm4Data) && sm4Data.startsWith(prefix)) {
                //byte[] inData = padding(Base64.decodeBase64(sm4Data.substring(prefix.length())),SM4_DECRYPT_MODEL);
                byte[] inData = Base64.decodeBase64(sm4Data.substring(prefix.length()));
                byte[] outdata = new byte[inData.length];
                int[] oulen = new int[1];

                int rv = fmapi.FM_CPC_Decrypt(KEY_NUM,
                        fmapi.FM_ALG_SM4, fmapi.FM_ALGMODE_ECB,
                        inData, inData.length,
                        outdata, oulen, null, 0, null, 0);
                if (rv != FME_OK) {
                    logger.error(sm4Data + "SM4解密失败！ FM_CPC_Decrypt 解密返回状态码：" + rv);
                    throw new RuntimeException(sm4Data + "SM4解密失败！ FM_CPC_Decrypt 解密返回状态码：" + rv);
                } else {
                    byte[] res = padding(outdata, SM4_DECRYPT_MODEL);
                    return new String(res, "UTF-8");
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return sm4Data;
    }

    /**
     * SM2加密
     *
     * @param sm2Indata
     * @return
     */
    public static String sm2EncryptHexStr(String sm2Indata) {
        try {
            if (StringUtils.isNotBlank(sm2Indata)) {
                byte[] inData = sm2Indata.getBytes("UTF-8");

                byte[] encData = new byte[260];
                int rv = fmapi.FM_CPC_ECCEncrypt(fmapi.FM_ALG_SM2_1, KEY_NUM, inData, inData.length, null, encData);
                if (rv != FME_OK) {
                    logger.error(sm2Indata + "SM2加密失败！ FM_CPC_ECCEncrypt 加密返回状态码：" + rv);
                } else {
                    return Hex.encodeHexString(encData);
                }
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sm2Indata;
    }

    /**
     * SM4解密
     *
     * @param sm2Hexdata
     * @return
     */
    public static String sm2DecryptHexStr(String sm2Hexdata) {
        try {
            if (StringUtils.isNotBlank(sm2Hexdata)) {
                byte[] inData = Hex.decodeHex(sm2Hexdata.toCharArray());
                byte[] outData = new byte[32];
                int[] outlen = new int[1];
                int rv = fmapi.FM_CPC_ECCDecrypt(fmapi.FM_ALG_SM2_1, KEY_NUM, inData, null, outData, outlen);
                if (rv != FME_OK) {
                    logger.error(sm2Hexdata + "SM2解密失败！ FM_CPC_ECCDecrypt 解密返回状态码：" + rv);
                    throw new RuntimeException(sm2Hexdata + "SM2解密失败！ FM_CPC_ECCDecrypt 解密返回状态码：" + rv);
                } else {
                    return new String(outData, "UTF-8");
                }
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (DecoderException e) {
            e.printStackTrace();
        }
        return sm2Hexdata;
    }

    public static byte[] sm3Final(byte[] inData) {
        if (null != inData) {
            //byte[] inData = sm3Indata.getBytes("UTF-8");
            byte[] outdata = new byte[32];
            int[] outlen = new int[1];
            //outlen[0] = 128;
            fmapi.FM_CPC_SM3Init(null, null, 0);
            fmapi.FM_CPC_SM3Update(inData, inData.length);
            int rv = fmapi.FM_CPC_SM3Final(outdata, outlen);
            if (rv != FME_OK) {
                logger.error("SM3Hash加密失败！ FM_CPC_SM3Final 加密返回状态码：" + rv);
            } else {
                return outdata;
            }
        }
        return null;
    }

    public static String sm3HMacHexStr(String sm3Indata) {
        try {
            if (StringUtils.isNotBlank(sm3Indata)) {
                byte[] k0opad = new byte[64];
                byte[] ctx = new byte[512];
                byte[] inData = sm3Indata.getBytes("UTF-8");
                byte[] outdata = new byte[inData.length];
                int[] outlen = new int[1];
                //byte[] pubkey = fmapi.FM_CPC_GetPubkey(1);
                fmapi.FM_CPC_HMAC_INIT_Ctx(KEY_NUM, null, 0, k0opad, ctx);
                fmapi.FM_CPC_HMAC_UPDATE_Ctx(inData, inData.length, ctx);
                int rv = fmapi.FM_CPC_HMAC_FINAL_Ctx(k0opad, ctx, outdata, outlen);
                if (rv != FME_OK) {
                    logger.error(sm3Indata + "SM3加密失败！ FM_CPC_SM3_Mac 加密返回状态码：" + rv);
                } else {
                    return Hex.encodeHexString(outdata);
                }
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return sm3Indata;
    }

    /**
     * SM2签名
     *
     * @param sm2SignData
     * @return
     */
    public static String sm2Sign(String sm2SignData) {
        try {
            if (StringUtils.isNotBlank(sm2SignData)) {
                if (sm2SignData.startsWith(prefix)) {
                    return sm2SignData;
                }
                byte[] inData = sm2SignData.getBytes("UTF-8");
                inData = sm3Final(inData);
                byte[] signData = new byte[64];
                int rv = fmapi.FM_CPC_ECCSign(KEY_NUM, inData, inData.length, null, signData);
                if (rv != FME_OK) {
                    logger.error(sm2SignData + "SM2签名失败！ FM_CPC_ECCSign 签名返回状态码：" + rv);
                } else {
                    return prefix + Hex.encodeHexString(signData);
                }
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }

        return sm2SignData;
    }

    /**
     * SM2签名验证
     *
     * @param sm2InData
     * @param sm2SignHexData
     * @return
     */
    public static boolean sm2VerifySign(String sm2InData, String sm2SignHexData) {
        try {
            if (StringUtils.isNotBlank(sm2InData) && StringUtils.isNotBlank(sm2SignHexData)) {
                if (sm2SignHexData.startsWith(prefix)) {
                    sm2SignHexData = sm2SignHexData.substring(prefix.length());
                }
                byte[] inData = sm2InData.getBytes("UTF-8");
                inData = sm3Final(inData);
                byte[] signData = Hex.decodeHex(sm2SignHexData.toCharArray());
                int rv = fmapi.FM_CPC_ECCVerify(KEY_NUM, null, inData, inData.length, signData);
                if (rv != FME_OK) {
                    logger.error(sm2InData + "SM2验签失败！ FM_CPC_ECCVerify 验签返回状态码：" + rv);
                } else {
                    return true;
                }
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (DecoderException e) {
            e.printStackTrace();
        }

        return false;
    }

    /**
     * 数组补位
     *
     * @param input
     * @param mode
     * @return
     */
    public static byte[] padding(byte[] input, int mode) {
        if (input == null) {
            return null;
        }

        //SM4加密补16的整数倍
        if (mode == SM4_ENCRYPT_MODEL) {
            int p = 16 - input.length % 16; // p：看最后要补多少位
            byte[] ret = new byte[input.length + p]; // ret：新的 16 倍数组
            System.arraycopy(input, 0, ret, 0, input.length); // 原内容拷到新数组
            /*for (int i = 0; i < p; i++)
            {
                ret[input.length + i] = (byte) p;
            }*/
            // 最后 p 位填充内容也为 p
            ret[input.length + p - 1] = (byte) p;
            return ret;
        }
        //SM4解密还原
        else if (mode == SM4_DECRYPT_MODEL) {
            int p = input[input.length - 1]; // 从最后一位读出 p，即补的位数
            byte[] ret = new byte[input.length - p]; // 生成原数组大小的新数组
            System.arraycopy(input, 0, ret, 0, input.length - p); // 把补位前的内容还原
            return ret;
        }
        return input;
    }

    /**
     * 获取对象签名值
     * @return
     */
    public static String getObjectSignStr(Object obj) {
        if (null != obj) {
            StringBuilder res = new StringBuilder();
            Field[] fields = obj.getClass().getDeclaredFields();
            for (Field field : fields) {
                FieldSign fieldSign = field.getAnnotation(FieldSign.class) ;
                if (null == fieldSign) {
                    continue;
                }
                try {
                    Object val = FieldUtils.readField(field, obj, true);
                    if (null != val) {
                        if (StringUtils.isNotBlank(res)) {
                            res.append(CONCAT_SYMBOL_AND).append(field.getName().toUpperCase()).append(CONCAT_SYMBOL_EQ).append(val.toString());
                        } else {
                            res.append(field.getName().toUpperCase()).append(CONCAT_SYMBOL_EQ).append(val.toString());
                        }
                    }
                } catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            return res.toString();
        }
        return null;
    }
}
