package cn.gtmap.realestate.supervise.model;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;

import static cn.gtmap.realestate.supervise.common.FinalNumber.ENCODE;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianjian</a>
 * @version 1.0, 2017/3/23
 * @description 文件消息
 */
public class FileMessage implements Serializable {

    //文件名称
    private String fileName;

    //文件二进制文件
    private byte[] content;

    //文件类型
    private String type;

    //文件编码
    private String encode;

    //文件存放路径
    private String path;

    //事件编号
    private String bizMsgId;

    //处理结果
    private String result;

    //业务类型
    private String rectype;

    //不动产单元号
    private String estateNum;

    //业务对应的地区编号
    private String areaCode;

    //数字签名
    private String sign;

    //重新入库标记 0：非重新入库，1：重新入库
    private String cxrkbj;

    //删除标记 1：删除
    private String scbj;

    //业务号
    private String recFlowID;

    //汇交方式(1：初始汇交，2：定期汇交、3：实时汇交)
    private String exchangeMode;

    //注销业务号
    private String logoutRecFlowID;

    //上次不动产权证号/不动产登记证明号
    private String preCertID;

    //上次来源不动产单元号
    private String preEstateNum;

    //接入标准ID
    private String ASID;

    //权利类型
    private String rightType;

    //登记类型
    private String regType;

    //登记机构
    private Date createDate;

    //宗地/宗海代码
    private String ParcelID;

    //登记类型
    private String regOrgID;

    //不动产权证号码数量
    private String certCount;

    //证明号码数量
    private String proofCount;

    //区块链序号
    private String xh;

    public FileMessage(String fileName, String type) {
        this.fileName = fileName;
        this.type = type;
    }

    public FileMessage() {

    }

    public String getFileName() {
        return fileName;
    }

    public byte[] getContent() {
        return content;
    }

    public String getType() {
        return type;
    }

    public String getPath() {
        return path;
    }

    public String getEncode() {

        return encode;
    }

    public String getResult() {
        return result;
    }

    public String getBizMsgId() {
        return bizMsgId;
    }

    public String getRectype() {
        return rectype;
    }

    public void setEncode(String encode) {
        this.encode = encode;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setBizMsgId(String bizMsgId) {
        this.bizMsgId = bizMsgId;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public void setRectype(String rectype) {
        this.rectype = rectype;
    }

    public String getAreaCode() {
        return areaCode;
    }

    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getCxrkbj() {
        return cxrkbj;
    }

    public void setCxrkbj(String cxrkbj) {
        this.cxrkbj = cxrkbj;
    }

    public String getScbj() {
        return scbj;
    }

    public void setScbj(String scbj) {
        this.scbj = scbj;
    }

    public String getEstateNum() {
        return estateNum;
    }

    public void setEstateNum(String estateNum) {
        this.estateNum = estateNum;
    }

    public String getRecFlowID() {
        return recFlowID;
    }

    public void setRecFlowID(String recFlowID) {
        this.recFlowID = recFlowID;
    }

    public String getExchangeMode() {
        return exchangeMode;
    }

    public void setExchangeMode(String exchangeMode) {
        this.exchangeMode = exchangeMode;
    }

    public String getLogoutRecFlowID() {
        return logoutRecFlowID;
    }

    public void setLogoutRecFlowID(String logoutRecFlowID) {
        this.logoutRecFlowID = logoutRecFlowID;
    }

    public String getPreCertID() {
        return preCertID;
    }

    public void setPreCertID(String preCertID) {
        this.preCertID = preCertID;
    }

    public String getPreEstateNum() {
        return preEstateNum;
    }

    public void setPreEstateNum(String preEstateNum) {
        this.preEstateNum = preEstateNum;
    }

    public String getASID() {
        return ASID;
    }

    public void setASID(String ASID) {
        this.ASID = ASID;
    }

    public String getRightType() {
        return rightType;
    }

    public void setRightType(String rightType) {
        this.rightType = rightType;
    }

    public String getRegType() {
        return regType;
    }

    public void setRegType(String regType) {
        this.regType = regType;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getRegOrgID() {
        return regOrgID;
    }

    public void setRegOrgID(String regOrgID) {
        this.regOrgID = regOrgID;
    }

    public String getParcelID() {
        return ParcelID;
    }

    public void setParcelID(String parcelID) {
        ParcelID = parcelID;
    }

    public String getCertCount() {
        return certCount;
    }

    public void setCertCount(String certCount) {
        this.certCount = certCount;
    }

    public String getProofCount() {
        return proofCount;
    }

    public void setProofCount(String proofCount) {
        this.proofCount = proofCount;
    }

    public String getXh() {
        return xh;
    }

    public void setXh(String xh) {
        this.xh = xh;
    }

    public String toString() {
        try {
            if (encode != null) {
                return new String(content, encode);
            } else {
                return new String(content, ENCODE);
            }

        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

}
