package cn.gtmap.realestate.supervise.entity;

import org.apache.commons.lang3.StringUtils;

import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 监管规则详情类
 */
@Table(name = "JG_RULE")
public class JgRule {

    @Id
    private String id;//主键

    private String ruleCode;//规则编码

    private String ruleName;//规则名称

    private String ruleType;//规则类型

    private String ruleState;//规则状态

    private Date lastDate;//最后执行时间

    private BigDecimal irregularityNum;//执行违规条数

    private String lastDateStr;

    private String ruleTypeName;

    private String ruleSql;//规则执行SQL

    private String ruleParam;//规则参数

    private String ruleMessage;//违规描述

    private String runType;//执行方式（SQL.CODE）

    private String ruleInfo;//规则信息

    private String ruleLevel; // 规则等级

    private String ruleLx; // 规则大类

    public JgRule() {

    }

    public JgRule(String ruleType, String ruleCode, String ruleName, String runType, String ruleInfo, String ruleLevel, String ruleLx) {
        this.ruleType = ruleType;
        this.ruleCode = ruleCode;
        this.ruleName = ruleName;
        this.runType = runType;
        this.ruleInfo = ruleInfo;
        this.ruleLevel = ruleLevel;
        this.ruleLx = ruleLx;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRuleCode() {
        return ruleCode;
    }

    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getRuleType() {
        return ruleType;
    }

    public void setRuleType(String ruleType) {
        this.ruleType = ruleType;
    }

    public String getRuleState() {
        return ruleState;
    }

    public void setRuleState(String ruleState) {
        this.ruleState = ruleState;
    }

    public Date getLastDate() {
        return lastDate;
    }

    public void setLastDate(Date lastDate) {
        this.lastDate = lastDate;
    }

    public BigDecimal getIrregularityNum() {
        return irregularityNum;
    }

    public void setIrregularityNum(BigDecimal irregularityNum) {
        this.irregularityNum = irregularityNum;
    }

    public String getRuleLx() {
        return ruleLx;
    }

    public void setRuleLx(String ruleLx) {
        this.ruleLx = ruleLx;
    }

    public void setLastDateStr(String lastDateStr) {
        this.lastDateStr = lastDateStr;
    }

    public String getRuleSql() {
        if (StringUtils.isNotBlank(ruleSql)) {
            return ruleSql;
        } else {
            return "";
        }
    }

    public void setRuleSql(String ruleSql) {
        this.ruleSql = ruleSql;
    }

    public String getRuleParam() {
        if (StringUtils.isNotBlank(ruleParam)) {
            return ruleParam;
        } else {
            return "";
        }
    }

    public void setRuleParam(String ruleParam) {
        this.ruleParam = ruleParam;
    }

    public String getRunType() {
        return runType;
    }

    public void setRunType(String runType) {
        this.runType = runType;
    }

    public String getRuleMessage() {
        if (StringUtils.isNotBlank(ruleMessage)) {
            return ruleMessage;
        } else {
            return "";
        }
    }

    public void setRuleMessage(String ruleMessage) {
        this.ruleMessage = ruleMessage;
    }

    public String getLastDateStr() {
        if (null != lastDate) {
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sf.format(lastDate);
        }
        return lastDateStr;
    }

    public String getRuleTypeName() {
        return ruleTypeName;
    }

    public void setRuleTypeName(String ruleTypeName) {
        this.ruleTypeName = ruleTypeName;
    }

    public String getRuleInfo() {
        return ruleInfo;
    }

    public void setRuleInfo(String ruleInfo) {
        this.ruleInfo = ruleInfo;
    }

    public String getRuleLevel() {
        return ruleLevel;
    }

    public void setRuleLevel(String ruleLevel) {
        this.ruleLevel = ruleLevel;
    }
}
