package cn.gtmap.realestate.supervise.service.impl;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.entity.XtGroup;
import cn.gtmap.realestate.supervise.entity.XtRegion;
import cn.gtmap.realestate.supervise.entity.XtUser;
import cn.gtmap.realestate.supervise.service.SecuritySSOHandleService;
import cn.gtmap.realestate.supervise.utils.HttpClientUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

import java.io.IOException;
import java.util.*;

/**
 * @author hqz
 * @version 1.0, 2017/6/8
 * @description 验证信息类
 */
public class SecuritySSOHandleServiceImpl implements SecuritySSOHandleService {
    @Override
    public UserAuthDTO validUser(String uuid) {
        String portalUrl = AppConfig.getProperty("portal.url");
        String url = portalUrl + "/remote/validUser";
        Map<String,String> paramMap = new HashMap<>();
        paramMap.put("uuid",uuid);
        UserAuthDTO userAuthDTO = null;
        try {
            String json  =  HttpClientUtil.sendHttpClient(url,paramMap);
            JSONObject jb = JSON.parseObject(json);
            userAuthDTO = jsonParseUser(jb);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return userAuthDTO;
    }

    @Override
    public boolean validResource(String url, String uuid, String groupNo) {
        String portalUrl = AppConfig.getProperty("portal.url");
        String validUrl = portalUrl + "/remote/validResource";
        Map<String,String> paramMap = new HashMap<>();
        paramMap.put("uuid",uuid);
        paramMap.put("url",url);
        paramMap.put("groupNo",groupNo);
        boolean isValid = false;
        try {
            isValid  =  Boolean.parseBoolean(HttpClientUtil.sendHttpClient(validUrl,paramMap));
        } catch (IOException e) {
            e.printStackTrace();
        }
        return isValid;
    }

    private UserAuthDTO jsonParseUser(JSONObject jo){
        UserAuthDTO userAuthDTO = null;
        if(null != jo){
            userAuthDTO = new UserAuthDTO();
            if(jo.containsKey("username")){
                userAuthDTO.setUsername((String)jo.get("username"));
            }
            if(jo.containsKey("isAdmin")){
                userAuthDTO.setIsAdmin((Boolean) jo.get("isAdmin"));
            }

            if(jo.containsKey("authorities")){
                JSONArray ja = (JSONArray)jo.get("authorities");
                JSONObject jsonObject;
                Set<GrantedAuthority> authSet = new HashSet<>();
                for(int i = 0;i < ja.size() ;i++){
                    jsonObject = (JSONObject) ja.get(i);
                    if(jsonObject.containsKey("authority")){
                        authSet.add( new SimpleGrantedAuthority((String)jsonObject.get("authority")));
                    }

                    userAuthDTO.setAuthorities(authSet);
                }
            }
            if (jo.containsKey("xtUser")){
                String userJson = JSON.toJSONString(jo.get("xtUser"));
                XtUser xtUser = JSONObject.parseObject(userJson,new TypeReference<XtUser>(){});
                //XtUser xtUser = JSON.parseObject(userJson,new TypeReference<XtUser>(){});
                userAuthDTO.setXtUser(xtUser);
            }
            if (jo.containsKey("regions")) {
                JSONArray ja = (JSONArray) jo.get("regions");
                List<Map<String, Object>> regions = new ArrayList<>();
                if(null!= ja && ja.size() > 0){
                    for(Object object : ja){
                        regions.add((Map<String, Object>)object);
                    }
                }
                userAuthDTO.setRegions(regions);
            }
            if (jo.containsKey("passwordTooSimple")) {
                userAuthDTO.setPasswordTooSimple((Boolean) jo.get("passwordTooSimple"));
            }
        }
        return userAuthDTO;
    }

    /**
     * @version 1.0, 2017/7/18
     * @author<a href = "mailto；liuxing@gtmap.cn">liuxing</a>
     * @description 获取单个行政区划
     */
    @Override
    public XtRegion getXzqhOne(String qhdm){
        XtRegion xtRegion = new XtRegion();
        String oneUrl = AppConfig.getProperty("portal.url") + "/remote/getXzqhOne";
        HashMap paraMap = new HashMap();
        paraMap.put("qhdm",qhdm);
        String regionJson = "";
        try {
            regionJson = HttpClientUtil.sendHttpClient(oneUrl, paraMap);
        }catch (IOException ioe){
            ioe.printStackTrace();
        }
        if (StringUtils.isNotBlank(regionJson)){
            regionJson = "[" + regionJson + "]";
            JSONArray ja = JSONArray.parseArray(regionJson);
            List<XtRegion> regionLst = jsonParseRegion(ja);
            xtRegion = regionLst.get(0);
        }
        return xtRegion;
    }


    /**
     * @version 1.0, 2017/7/18
     * @author<a href = "mailto；liuxing@gtmap.cn">liuxing</a>
     * @description 获取当前及其下属行政区划
     */
    @Override
    public List<XtRegion> getXzqhNext(String qhdm){
        String nextUrl = AppConfig.getProperty("portal.url") + "/remote/getXzqhNext";
        HashMap paraMap = new HashMap();
        paraMap.put("qhdm",qhdm);
        String regionJson = "";
        try {
            regionJson = HttpClientUtil.sendHttpClient(nextUrl, paraMap);
        }catch (IOException ioe){
            ioe.printStackTrace();
        }
        List<XtRegion> regionLst = new ArrayList<>();
        if (StringUtils.isNotBlank(regionJson)){
            regionLst = JSON.parseObject(regionJson,new TypeReference<List<XtRegion>>(){});
        }
        return regionLst;
    }


    /**
     * @author <a href="mailto:liujie@gtmap.cn">liujie</a>
     * @param qhdm 区划代码
     * @param level 区划级别
     * @return
     * @description 获取对应级别的行政区划列表信息
     */
    @Override
    public List<XtRegion> getLevelXzqh(String qhdm, String level){
        String nextUrl = AppConfig.getProperty("portal.url") + "/remote/getLevelXzqh";
        HashMap paraMap = new HashMap();
        paraMap.put("qhdm",qhdm);
        paraMap.put("level",level);
        String regionJson = "";
        try {
            regionJson = HttpClientUtil.sendHttpClient(nextUrl, paraMap);
        }catch (IOException ioe){
            ioe.printStackTrace();
        }
        List<XtRegion> regionLst = new ArrayList<>();
        if (StringUtils.isNotBlank(regionJson)){
            regionLst = JSON.parseObject(regionJson,new TypeReference<List<XtRegion>>(){});
        }
        return regionLst;
    }

    public List<XtRegion> getCurruserRegion(String userId){
        String nextUrl = AppConfig.getProperty("portal.url") + "/remote/getCurruserRegion";
        HashMap paraMap = new HashMap();
        paraMap.put("userid",userId);
        String regionJson = "";
        List<XtRegion> regionLst = new ArrayList<>();
        try {
            regionJson = HttpClientUtil.sendHttpClient(nextUrl, paraMap);
        }catch (IOException ioe){
            ioe.printStackTrace();
        }
        if (StringUtils.isNotBlank(regionJson)){
            //JSONObject jsonObject = JSONObject.parseObject(regionJson);
            regionLst = JSON.parseObject(regionJson,new TypeReference<List<XtRegion>>() {});
        }
        return regionLst;
    }

    /**
     * @version 1.0, 2017/7/18
     * @author<a href = "mailto；liuxing@gtmap.cn">liuxing</a>
     * @description 从json数组中获取行政区划信息
     */
    public List<XtRegion> jsonParseRegion(JSONArray ja){
        List<XtRegion> resultLst =  new ArrayList<>();
        if (null != ja){
            JSONObject jsonObject;
            for(int i = 0; i < ja.size(); i ++){
                XtRegion xtRegion = new XtRegion();
                jsonObject = (JSONObject)ja.get(i);
                if (jsonObject.containsKey("regionId") && null != jsonObject.get("regionId")){
                    xtRegion.setRegion_id(jsonObject.get("regionId").toString());
                }
                if (jsonObject.containsKey("qhdm") && null != jsonObject.get("qhdm")){
                    xtRegion.setQhdm(jsonObject.get("qhdm").toString());
                }
                if (jsonObject.containsKey("qhmc") && null != jsonObject.get("qhmc")){
                    xtRegion.setQhmc(jsonObject.get("qhmc").toString());
                }
                if (jsonObject.containsKey("fdm") && null != jsonObject.get("fdm")){
                    xtRegion.setFdm(jsonObject.get("fdm").toString());
                }
                if (jsonObject.containsKey("qhjb") && null != jsonObject.get("qhjb")){
                    xtRegion.setQhjb(jsonObject.get("qhjb").toString());
                }
                resultLst.add(xtRegion);
            }
        }
        return resultLst;
    }

    public List<XtGroup> getCurruserGroup(String userId){
        String nextUrl = AppConfig.getProperty("portal.url") + "/remote/getCurruserGroup";
        HashMap paraMap = new HashMap();
        paraMap.put("userid",userId);
        String groupJson = "";
        List<XtGroup> groupLst = new ArrayList<>();
        try {
            groupJson = HttpClientUtil.sendHttpClient(nextUrl, paraMap);
        }catch (IOException ioe){
            ioe.printStackTrace();
        }
        if (StringUtils.isNotBlank(groupJson)){
            groupLst = JSON.parseObject(groupJson,new TypeReference<List<XtGroup>>() {});
        }
        return groupLst;
    }
}
