/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.utils.AESEncrypter;
import cn.gtmap.realestate.supervise.utils.JedisPoolUtil;
import cn.gtmap.realestate.supervise.utils.TimeUtils;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;

public class OpenIdPool {
    private static OpenIdPool openIdPool = null;
    private static final String publickey = "gtmap_exchange_openId";
    private static final int validMinute = 60;
    private static final String REDIS_OPENID = "OPENID";

    private OpenIdPool() {
    }

    public static OpenIdPool getOpenIdPoolInstance() {
        if (null == openIdPool) {
            openIdPool = new OpenIdPool();
        }
        return openIdPool;
    }

    public synchronized String getOpenId(String userId) {
        String openId = null;
        if (StringUtils.isNotBlank((CharSequence)userId)) {
            Date now = new Date(System.currentTimeMillis());
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMddHHmmss");
            String strNow = sf.format(now);
            String content = userId + "|" + strNow;
            byte[] bytes = AESEncrypter.encrypt(content, publickey);
            openId = OpenIdPool.byteArrayToHexStr(bytes);
            Jedis jedis = JedisPoolUtil.getJedis();
            HashMap map = Maps.newHashMap();
            map.put("openId_" + userId, openId);
            map.put("time_" + userId, strNow);
            jedis.hmset(REDIS_OPENID, (Map)map);
            jedis.close();
        }
        return openId;
    }

    public synchronized boolean validOpenId(String openId) {
        boolean isflag = false;
        if (StringUtils.isNotBlank((CharSequence)openId)) {
            Jedis jedis = JedisPoolUtil.getJedis();
            Map maps = jedis.hgetAll(REDIS_OPENID);
            if (maps.containsValue(openId)) {
                String timeKey;
                String time;
                Date oldDate;
                boolean isValid;
                String openIdKey = "";
                for (Map.Entry entry : maps.entrySet()) {
                    if (!openId.equals(entry.getValue()) || !StringUtils.isBlank((CharSequence)openIdKey)) continue;
                    openIdKey = (String)entry.getKey();
                    break;
                }
                if (!(isValid = this.validDate(oldDate = TimeUtils.strToDateTime(time = jedis.hget(REDIS_OPENID, timeKey = openIdKey.replace("openId", "time")))))) {
                    jedis.hdel(REDIS_OPENID, new String[]{timeKey, openIdKey});
                }
                isflag = isValid;
            }
            jedis.close();
        }
        return isflag;
    }

    public synchronized void removeOpenId(String openId) {
        if (StringUtils.isNotBlank((CharSequence)openId)) {
            Jedis jedis = JedisPoolUtil.getJedis();
            Map maps = jedis.hgetAll(REDIS_OPENID);
            if (maps.containsValue(openId)) {
                String openIdKey = "";
                for (Map.Entry entry : maps.entrySet()) {
                    if (!openId.equals(entry.getValue()) || !StringUtils.isBlank((CharSequence)openIdKey)) continue;
                    openIdKey = (String)entry.getKey();
                    break;
                }
                String timeKey = openIdKey.replace("openId", "time");
                jedis.hdel(REDIS_OPENID, new String[]{timeKey, openIdKey});
            }
            jedis.close();
        }
    }

    private boolean validDate(Date initDate) {
        Calendar cd = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        cd.setTime(initDate);
        cd.add(12, 60);
        return now.before(cd);
    }

    public static String byteArrayToHexStr(byte[] byteArray) {
        if (byteArray == null) {
            return null;
        }
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[byteArray.length * 2];
        for (int j = 0; j < byteArray.length; ++j) {
            int v = byteArray[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }
}

