/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.supervise.common;

import cn.gtmap.estateplat.core.ex.AppException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TimeUtils {
    public static String getTimeStr(Date date, String format) {
        String timeStr;
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        try {
            timeStr = sdf.format(date);
        }
        catch (Exception e) {
            timeStr = "";
        }
        return timeStr;
    }

    public static Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDayEnd() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static Date getBeginDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(TimeUtils.getNowYear(), TimeUtils.getNowMonth() - 1, 1);
        return TimeUtils.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(TimeUtils.getNowYear(), TimeUtils.getNowMonth() - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(TimeUtils.getNowYear(), TimeUtils.getNowMonth() - 1, day);
        return TimeUtils.getDayEndTime(calendar.getTime());
    }

    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date strToDate(String time) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Date date = null;
        try {
            date = sdf.parse(time);
        }
        catch (ParseException e) {
            throw new AppException(2026, new Object[0]);
        }
        return date;
    }

    public static Date getNewDay(Date SourceDate, int year, int month, int day) {
        Date newDate = null;
        Calendar newCalendar = Calendar.getInstance();
        newCalendar.setTime(SourceDate);
        newCalendar.add(1, year);
        newCalendar.add(2, month);
        newCalendar.add(6, day);
        newDate = newCalendar.getTime();
        return newDate;
    }
}

