package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.service.SecuritySSOHandleService;
import cn.gtmap.realestate.supervise.service.impl.SecuritySSOHandleServiceImpl;
import com.gtis.config.AppConfig;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * 操作日志工具类
 * @author szh
 */
public class OperationalLogUtil {

    private static SecuritySSOHandleService securitySSOHandleService = new SecuritySSOHandleServiceImpl();

    private static String URL = AppConfig.getProperty("portal.url") + "/log/save";


    /**
     * 记录操作日志
     * @param request request
     * @param czlx 操作类型
     * @param gnmc 功能名称
     * @param xtmc 系统名称
     */
    public static void log(HttpServletRequest request, String czlx, String gnmc, String xtmc) {
        Map<String, String> paramMap = new HashMap<>(12);
        paramMap.put("czyh",getCurrentUser(request)==null?"":getCurrentUser(request).getXtUser().getUserName());
        paramMap.put("czlx",czlx);
        paramMap.put("gnmc",gnmc);
        paramMap.put("xtmc",xtmc);
        paramMap.put("ip",getIpAddr(request));
        try {
            HttpClientUtil.sendHttpClient(URL,paramMap);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 记录操作日志
     * @param request request
     * @param czlx 操作类型
     * @param gnmc 功能名称
     * @param xtmc 系统名称
     */
    public static void log(HttpServletRequest request,String czyh, String czlx, String gnmc, String xtmc) {
        Map<String, String> paramMap = new HashMap<>(12);
        paramMap.put("czyh",czyh);
        paramMap.put("czlx",czlx);
        paramMap.put("gnmc",gnmc);
        paramMap.put("xtmc",xtmc);
        paramMap.put("ip",getIpAddr(request));
        try {
            HttpClientUtil.sendHttpClient(URL,paramMap);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 获取ip
     * @param request
     * @return
     */
    public static String getIpAddr(HttpServletRequest request){
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    /**
     * 获取用户
     * @param request
     * @return
     */
    public static UserAuthDTO getCurrentUser(HttpServletRequest request){
        String cookieName = AppConfig.getProperty("platform.cookiename");
        Cookie[] diskCookies = request.getCookies();
        String cookieValue;
        UserAuthDTO userAuthDTO = null;
        if (diskCookies != null) {
            for (int i = 0; i < diskCookies.length; ++i) {
                if (diskCookies[i].getName().equals(cookieName)) {
                    cookieValue = diskCookies[i].getValue();
                    userAuthDTO = securitySSOHandleService.validUser(cookieValue);
                }
            }
        }
        return userAuthDTO;
    }
}
