package cn.gtmap.realestate.supervise.utils;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSource;
import com.google.common.io.Files;

import java.io.*;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author <a href="mailto:tianjian@gtmap.cn">tianian</a>
 * @version 1.0, 2017/8/11
 * @description
 */
public class FileUtil {

    public static byte[] getBytes(File file)  {
        ByteSource byteSource = null;

        byteSource = Files.asByteSource(file);
        byte[] outBytes = new byte[0];
        try {
            outBytes = byteSource.read();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return outBytes;
    }

    public static boolean saveFile( byte[] content,File file) {

        try {

            Files.write(content, file);

            return true;

        } catch (IOException e) {
            e.printStackTrace();

            return false;
        }
    }

    public static String getFileAsString(File file) throws IOException {

        BufferedReader reader = null;

        String fileString = null;

        try {

            reader = Files.newReader(file, Charsets.UTF_8);

        } catch (FileNotFoundException e) {

            e.printStackTrace();

        } finally {

            reader.close();

            return fileString;

        }
    }

    public static boolean removeFile(File file) {

        return file.delete();

    }

    public static List<File> getFilesByPath(File file, FileFilter fileFilter) {

        List<File> allFile = new ArrayList<File>();

        if (!file.exists()) {
            return null;
        }

        File[] files = file.listFiles();

        for (File fileDetail : files) {

            if (fileDetail.isFile()) {

                if (fileFilter != null && !fileFilter.accept(fileDetail)) {
                    continue;
                }

                allFile.add(fileDetail);
            }

            if (fileDetail.isDirectory()) {

                getFilesByPath(fileDetail, fileFilter);

            }
        }

        return allFile;
    }

    public static List<File> getFiles(String path) {
        List<File> filess = new ArrayList<File>();
        File file = new File(path);
        if (file.exists()) {
            XmlStemFilter xmlStemFilter = new XmlStemFilter();
            File[] files = file.listFiles();
            Arrays.sort(files);
            if (null == files || files.length == 0) {
//                System.out.println("文件夹是空的!");
                return Lists.newArrayList();
            } else {
                for (File file2 : files) {
                    if (file2.isDirectory()) {
                        String tempPath = file2.getAbsolutePath();
                        List<File> fileList = getFiles(tempPath);
                        if (null != fileList && !fileList.isEmpty()) {
                            for (File fileTemp : fileList) {
                                if (xmlStemFilter.accept(fileTemp)) {
                                    filess.add(fileTemp);
                                }
                            }
                        }

                    } else {
                        if (xmlStemFilter.accept(file2)) {
                            filess.add(file2);
                        }
                    }
                }
            }
        } else {
            file.mkdirs();
        }
        return filess;
    }


    public static List<File> getXSDFiles(String path) {
        List<File> filess = new ArrayList<File>();
        File file = new File(path);
        if (file.exists()) {
            File[] files = file.listFiles();
            if (null == files || files.length == 0) {
                System.out.println("XSD文件夹是空的!");
                return Lists.newArrayList();
            } else {
                for (File file2 : files) {
                    if (file2.isDirectory()) {
                        String tempPath = file2.getAbsolutePath();
                        List<File> fileList = getFiles(tempPath);
                        if (null != fileList && !fileList.isEmpty()) {
                            for (File fileTemp : fileList) {
                                filess.add(fileTemp);
                            }
                        }
                    } else {
                        filess.add(file2);
                    }
                }
            }
        } else {
            file.mkdirs();
        }
        return filess;
    }

    public static String getFileString(File file) {
        StringBuffer data = new StringBuffer();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(new FileInputStream(file), "UTF-8"));
            String str;
            while ((str = in.readLine()) != null) {
                data.append(str + "\n");
            }
            in.close();

        } catch (IOException e) {
            e.getStackTrace();

        }finally {
            try {
                if(null!=in){
                    in.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }

        }
        return data.toString();
    }
}
