package cn.gtmap.realestate.supervise.utils;

import cn.gtmap.estateplat.core.ex.AppException;
import cn.gtmap.realestate.supervise.common.Constant;
import cn.gtmap.realestate.supervise.model.GxRespData;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;

import java.lang.reflect.Method;

/**
 * @author hqz
 * @version 1.0, 2017/7/10
 * @description 访问接口校验AOP
 */
@Aspect
@Order(2)
public class CheckTokenAdvice {
    @Pointcut("@annotation(cn.gtmap.realestate.supervise.utils.CheckToken)")
    public void anyMethod(){
    }

    @Around("anyMethod()")
    public Object doBasicProfiling(ProceedingJoinPoint pjp) {
        GxRespData gxRespData = new GxRespData();
        Object object = null;
        Object[] args = pjp.getArgs();//传入的参数
        if(null != args){
            String gxDataStr = (String) args[0];
            String isAdmin = null;
            if(args.length > 1){
                isAdmin = (String) args[1];
            }
            if(StringUtils.isNotBlank(gxDataStr)) {
                if(StringUtils.isBlank(isAdmin) || !StringUtils.equals(isAdmin,"yes")){
                    Method method = this.getMethod(pjp);
                    CheckToken auditMethodCheck = method.getAnnotation(CheckToken.class);
                    Class clazz = auditMethodCheck.receiveClass();
                    Object obj = JSONObject.parseObject(gxDataStr, clazz);
                    String token = "";
                    try {
                        Method m1 = clazz.getMethod("getToken");
                        token = (String) m1.invoke(obj);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }

                    if (StringUtils.isNotBlank(token)) {
                        TokenPool tokenPool = TokenPoolFactory.getTokenPoolInstance();
                        boolean isValid = tokenPool.validToken(token);
                        if (isValid) {
                            try {
                                object = pjp.proceed();
                            } catch (Throwable throwable) {
                                int code = Constant.XTYC;
                                gxRespData.setCode(String.valueOf(code));
                                gxRespData.setMsg(Constant.getMsg(code));
                                object = gxRespData;
                            }
                        } else {
                            gxRespData.setCode(String.valueOf(Constant.TOKEN));
                            gxRespData.setMsg(Constant.getMsg(Constant.TOKEN));
                            object = gxRespData;
                        }
                    }
                } else {
                    try {
                        object = pjp.proceed();
                    } catch (Throwable throwable) {
                        int code = Constant.XTYC;
                        gxRespData.setCode(String.valueOf(code));
                        gxRespData.setMsg(Constant.getMsg(code));
                        object = gxRespData;
                    }
                }
            }
        }else{
            gxRespData.setCode(String.valueOf(Constant.TOKEN));
            gxRespData.setMsg(Constant.getMsg(Constant.TOKEN));
            object = gxRespData;
        }

        return object;

    }

    private Method getMethod(JoinPoint joinPoint) {
        Method var8;
        Class<?>[] par = ((MethodSignature) joinPoint.getSignature()).getParameterTypes();

        try {
            var8 = joinPoint.getTarget().getClass().getMethod(joinPoint.getSignature().getName(), par);
        } catch (NoSuchMethodException var6) {
            var6.printStackTrace();
            throw new AppException(var6,3001);
        }

        return var8;
    }
}
