package cn.gtmap.realestate.supervise.service;


import cn.gtmap.realestate.supervise.constant.Constant;
import cn.gtmap.realestate.supervise.entity.UserAuthDTO;
import cn.gtmap.realestate.supervise.service.impl.SecuritySSOHandleServiceImpl;
import cn.gtmap.realestate.supervise.utils.AESSecutiryUtil;
import cn.gtmap.realestate.supervise.utils.IpUtil;
import cn.gtmap.realestate.supervise.utils.OperationalLogUtil;
import com.gtis.config.AppConfig;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;



/**
 * @author hqz
 * @version 1.0, 2017/5/3
 * @description 认证控制过滤器
 */
public class SecurityUrlCheckFilter implements Filter {

    /**
     * 需要排除的页面
     */
    private String excludedPages;
    private String[] excludedPageArray;
    private SecuritySSOHandleService securitySSOHandleService = new SecuritySSOHandleServiceImpl();
    private String SSOLoginPage = AppConfig.getProperty("portal.url") + "/loginPage";
    private String noPermissionPage = AppConfig.getProperty("portal.url") + "/401";
    private String otherPortalUrl = AppConfig.getProperty("other.portal.url");

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        excludedPages = filterConfig.getInitParameter("excludedPages");
        if (StringUtils.isNotEmpty(excludedPages)) {
            excludedPageArray = excludedPages.split(",");
        }
        if(excludedPageArray!=null&&excludedPageArray.length != 0){
            for(int i = 0; i < excludedPageArray.length; i++){
                excludedPageArray[i] = StringUtils.trim(excludedPageArray[i]);
            }
        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String url = httpRequest.getServletPath();
        String groupName = StringUtils.substring(httpRequest.getContextPath(),1);
        boolean isExcludedPage = false;
        if(excludedPageArray != null) {
            for (String page : excludedPageArray) {//判断是否在过滤url之外
                if(validUrl(url,page)){
                    isExcludedPage = true;
                    break;
                }
            }
        }

        if (isExcludedPage) {//在过滤url之外
            chain.doFilter(request, response);
        } else {
            String cookieName = AppConfig.getProperty("platform.cookiename");
            Cookie[] diskCookies = httpRequest.getCookies();
            String cookieValue;
            boolean flag = false;
            if (diskCookies != null) {
                for (int i = 0; i < diskCookies.length; ++i) {
                    if (diskCookies[i].getName().equals(cookieName)) {
                        cookieValue = diskCookies[i].getValue();
                        String ip = IpUtil.getIpAddr(httpRequest);
                        String[] cookieValues = cookieValue.split("ip");
                        if(cookieValues.length == 2 && StringUtils.equals(ip, AESSecutiryUtil.decrypt(cookieValues[1]))) {
                            //验证是否有用户登录
                            UserAuthDTO userAuthDTO = securitySSOHandleService.validUser(cookieValue);
                            if (null == userAuthDTO) {
                                if (StringUtils.isNotBlank(this.otherPortalUrl)) {
                                    httpResponse.sendRedirect(this.otherPortalUrl);
                                } else {
                                    httpResponse.sendRedirect(this.SSOLoginPage);
                                }
                            } else {
                                //验证用户是否具有权限访问资源
                                boolean isValid = securitySSOHandleService.validResource(url, cookieValue, groupName);
                                if (isValid) {
                                    chain.doFilter(request, response);
                                } else {
                                    OperationalLogUtil.log(httpRequest,"9","无权访问:" + url, Constant.PORTAL);
                                    httpResponse.sendRedirect(this.noPermissionPage);
                                }
                            }
                        }
                        flag = true;
                    }
                }
            }
            if (!flag) {
                httpResponse.sendRedirect(this.SSOLoginPage);
            }
        }
    }

    /**
     * 验证当前请求是否需要过滤
     * @param url 请求地址
     * @param excludedPage 去除的页面
     * @return 是否需要过滤
     */
    private boolean validUrl(String url,String excludedPage){
        if(excludedPage.endsWith("/*") || excludedPage.endsWith("/**")){
            excludedPage = excludedPage.replace("*","");
        }
        return url.startsWith(excludedPage) || StringUtils.equals(url,excludedPage.substring(0,excludedPage.length()-1));
    }

    @Override
    public void destroy() {
    }
}
