/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.util;

import java.io.UnsupportedEncodingException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private static Pattern pattern = Pattern.compile("[0-9a-zA-Z]");
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String ENCODING_GBK = "GBK";

    public static byte[] strToByteUtf8(String str) {
        return StringUtil.strToByte(str, ENCODING_UTF8);
    }

    public static byte[] strToByteGbk(String str) {
        return StringUtil.strToByte(str, ENCODING_GBK);
    }

    public static byte[] strToByte(String str, String encode) {
        byte[] b = null;
        if (StringUtils.isNotBlank((CharSequence)str)) {
            try {
                b = str.getBytes(encode);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return b;
    }

    public static String byteToStrUtf8(byte[] b) {
        return StringUtil.byteToStr(b, ENCODING_UTF8);
    }

    public static String byteToStrGbk(byte[] b) {
        return StringUtil.byteToStr(b, ENCODING_GBK);
    }

    public static String byteToStr(byte[] b, String encode) {
        String str = null;
        if (null != b) {
            try {
                str = new String(b, encode);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return str;
    }

    public static String getSymbol(String symbol, Integer num) {
        if (null != num) {
            StringBuilder res = new StringBuilder();
            for (int i = 0; i < num; ++i) {
                res.append(symbol);
            }
            return res.toString();
        }
        return symbol;
    }
}

