/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.util;

import cn.gtmap.realestate.model.encrypt.SM4;
import cn.gtmap.realestate.model.encrypt.SM4_Context;
import cn.gtmap.realestate.util.Base64Util;
import cn.gtmap.realestate.util.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SM4Util {
    public static String secretKey = "SM4_GTMAP_SECRET";
    public static String iv = "SM4_GTMAP_IV_CBC";
    public static boolean hexString = false;
    public static Pattern p = Pattern.compile("\\s*|\t|\r|\n");

    public static String encryptData_ECB(String plainText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = hexString ? SM4Util.hexStringToBytes(secretKey) : secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, StringUtil.strToByteGbk(plainText));
            String cipherText = Base64Util.encodeByteToBase64Str(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptData_ECB(String cipherText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = hexString ? SM4Util.hexStringToBytes(secretKey) : secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_ecb(ctx, Base64Util.decodeBase64StrToByte(cipherText));
            return StringUtil.byteToStrGbk(decrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptData_CBC(String plainText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (hexString) {
                keyBytes = SM4Util.hexStringToBytes(secretKey);
                ivBytes = SM4Util.hexStringToBytes(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, StringUtil.strToByteGbk(plainText));
            String cipherText = Base64Util.encodeByteToBase64Str(encrypted);
            if (cipherText != null && cipherText.trim().length() > 0) {
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String decryptData_CBC(String cipherText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (hexString) {
                keyBytes = SM4Util.hexStringToBytes(secretKey);
                ivBytes = SM4Util.hexStringToBytes(iv);
            } else {
                keyBytes = secretKey.getBytes();
                ivBytes = iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, Base64Util.decodeBase64StrToByte(cipherText));
            return StringUtil.byteToStrGbk(decrypted);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(SM4Util.charToByte(hexChars[pos]) << 4 | SM4Util.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    public static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    private SM4Util() {
    }

    public static void main(String[] args) {
        String str = "3B9f15IgPlfN2UWI5ZRTjVY+nDg4hZCN3wOjT5FQ6zRpBm4P7xEUbtpFTqjWdETM";
        System.out.println("\u89e3\u5bc6\u540e\u660e\u6587\uff1a" + SM4Util.decryptData_ECB(str));
    }
}

