/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.util;

import cn.gtmap.realestate.enums.DesensitizerItem;
import cn.gtmap.realestate.service.Desensitizer;
import cn.gtmap.realestate.service.impl.BaseDesensitizer;
import cn.gtmap.realestate.service.impl.ReplaceDesensitizer;
import cn.gtmap.realestate.service.impl.Sm4EncryptDesensitizer;

public class DesensitizeUtil {
    public static String desensitize(String msg, DesensitizerItem desensitizerItem) {
        return DesensitizeUtil.getDesensitizer(desensitizerItem).desensitize(msg);
    }

    public static Object desensitize(Object obj, DesensitizerItem desensitizerItem) {
        return DesensitizeUtil.getDesensitizer(desensitizerItem).desensitize(obj);
    }

    public static void desensitize(Object[] objs, DesensitizerItem desensitizerItem) {
        DesensitizeUtil.getDesensitizer(desensitizerItem).desensitize(objs);
    }

    public static String reduction(String msg, DesensitizerItem desensitizerItem) {
        return DesensitizeUtil.getDesensitizer(desensitizerItem).reduction(msg);
    }

    public static Object reduction(Object obj, DesensitizerItem desensitizerItem) {
        return DesensitizeUtil.getDesensitizer(desensitizerItem).reduction(obj);
    }

    public static void reduction(Object[] objs, DesensitizerItem desensitizerItem) {
        DesensitizeUtil.getDesensitizer(desensitizerItem).reduction(objs);
    }

    public static Desensitizer getDesensitizer(DesensitizerItem desensitizerItem) {
        BaseDesensitizer desensitizer;
        switch (desensitizerItem) {
            case replace: {
                desensitizer = new ReplaceDesensitizer();
                break;
            }
            case sm4: {
                desensitizer = new Sm4EncryptDesensitizer();
                break;
            }
            default: {
                desensitizer = new ReplaceDesensitizer();
            }
        }
        return desensitizer;
    }

    private DesensitizeUtil() {
    }
}

