/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.service.impl;

import cn.gtmap.realestate.enums.DesensitizerMethod;
import cn.gtmap.realestate.model.ReplaceRuler;
import cn.gtmap.realestate.service.Desensitizer;
import cn.gtmap.realestate.util.DesConstants;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;

public abstract class BaseDesensitizer
implements Desensitizer {
    protected ReplaceRuler replaceRuler;
    protected DesensitizerMethod desensitizerMethod;

    public String execute(String msg, DesensitizerMethod desensitizerMethod) {
        if (DesConstants.properties.isDesensitizerSwitch()) {
            msg = msg.replaceAll("\\s*", "");
            msg = msg.replaceAll("[\\\\]+", "\\\\");
            if (null != DesConstants.rulers && DesConstants.rulers.size() > 0) {
                Iterator<ReplaceRuler> i$ = DesConstants.rulers.iterator();
                while (i$.hasNext()) {
                    ReplaceRuler replaceRuler;
                    this.replaceRuler = replaceRuler = i$.next();
                    this.desensitizerMethod = desensitizerMethod;
                    msg = this.msgSubstring(msg, this.replaceRuler.getRulerKeys());
                }
            }
        }
        return msg;
    }

    @Override
    public String desensitize(String msg) {
        return this.execute(msg, DesensitizerMethod.desensitize);
    }

    @Override
    public Object desensitize(Object obj) {
        String res = this.desensitize(JSON.toJSONString((Object)obj));
        return JSON.parseObject((String)res, obj.getClass());
    }

    @Override
    public void desensitize(Object[] objs) {
        if (null != objs) {
            for (int i = 0; i < objs.length; ++i) {
                objs[i] = objs[i] instanceof String ? this.desensitize((String)objs[i]) : this.desensitize(objs[i]);
            }
        }
    }

    @Override
    public String reduction(String msg) {
        return this.execute(msg, DesensitizerMethod.reduction);
    }

    @Override
    public Object reduction(Object obj) {
        String res = this.reduction(JSON.toJSONString((Object)obj));
        return JSON.parseObject((String)res, obj.getClass());
    }

    @Override
    public void reduction(Object[] objs) {
        if (null != objs) {
            for (int i = 0; i < objs.length; ++i) {
                objs[i] = objs[i] instanceof String ? this.reduction((String)objs[i]) : this.reduction(objs[i]);
            }
        }
    }

    @Override
    public String handle(String value, ReplaceRuler replaceRuler) {
        String res;
        switch (this.desensitizerMethod) {
            case desensitize: {
                res = this.desHandle(value, replaceRuler);
                break;
            }
            case reduction: {
                res = this.redHandle(value);
                break;
            }
            default: {
                res = value;
            }
        }
        return res;
    }

    @Override
    public String desHandle(String value, ReplaceRuler replaceRuler) {
        return value;
    }

    @Override
    public String redHandle(String value) {
        return value;
    }

    private String msgSubstring(String msg, List<String> keys) {
        for (String key : keys) {
            String subKey = '\"' + key + '\"' + ":";
            if (msg.contains(subKey)) {
                msg = this.msgSubstringHandle(msg, subKey);
                continue;
            }
            subKey = "\\\"" + key + "\\\"" + ":";
            if (msg.contains(subKey)) {
                msg = this.msgSubstringHandle(msg, subKey);
                continue;
            }
            for (String symbol : DesConstants.subSymbols) {
                msg = this.msgSubstringHandle(msg, key + symbol);
            }
        }
        return msg;
    }

    private String msgSubstringHandle(String msg, String subKey) {
        int index = -1;
        do {
            if ((index = msg.indexOf(subKey, index + 1)) == -1) continue;
            int valueStart = this.getValueStartIndex(msg, index + subKey.length());
            int valueEnd = this.getValueEndIndex(msg, valueStart);
            String subStr = msg.substring(valueStart, valueEnd);
            subStr = this.handle(subStr, this.replaceRuler);
            msg = msg.substring(0, valueStart) + subStr + msg.substring(valueEnd);
        } while (index != -1);
        return msg;
    }

    private int getValueStartIndex(String msg, int valueStart) {
        char ch;
        do {
            ch = msg.charAt(valueStart);
        } while (Lists.newArrayList((Object[])new Character[]{Character.valueOf('='), Character.valueOf('\uff1b'), Character.valueOf('\"'), Character.valueOf('\\')}).contains(Character.valueOf(ch)) && ++valueStart != msg.length());
        return valueStart;
    }

    private int getValueEndIndex(String msg, int valueEnd) {
        char ch;
        do {
            ch = msg.charAt(valueEnd);
        } while (!Lists.newArrayList((Object[])new Character[]{Character.valueOf(','), Character.valueOf('\uff0c'), Character.valueOf(']'), Character.valueOf('}'), Character.valueOf('\"'), Character.valueOf('\\')}).contains(Character.valueOf(ch)) && ++valueEnd != msg.length());
        return valueEnd;
    }

    public ReplaceRuler getReplaceRuler() {
        return this.replaceRuler;
    }

    public void setReplaceRuler(ReplaceRuler replaceRuler) {
        this.replaceRuler = replaceRuler;
    }

    public DesensitizerMethod getDesensitizerMethod() {
        return this.desensitizerMethod;
    }

    public void setDesensitizerMethod(DesensitizerMethod desensitizerMethod) {
        this.desensitizerMethod = desensitizerMethod;
    }
}

