/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.realestate.factory;

import cn.gtmap.realestate.model.ReplaceRuler;
import cn.gtmap.realestate.service.Replace;
import cn.gtmap.realestate.service.impl.ShowLeftReplace;
import cn.gtmap.realestate.service.impl.ShowRightReplace;
import cn.gtmap.realestate.service.impl.ShowTwoSidesReplace;
import cn.gtmap.realestate.util.DesConstants;

public class ReplaceRulerFactory {
    private static ReplaceRulerFactory instance = new ReplaceRulerFactory();

    private ReplaceRulerFactory() {
    }

    public static ReplaceRulerFactory getInstance() {
        return instance;
    }

    public Replace getReplace(ReplaceRuler replaceRuler) {
        Replace replace = null;
        switch (replaceRuler.getRulerItem()) {
            case left: {
                replace = new ShowLeftReplace(replaceRuler.getReplaceNum(), DesConstants.symbol);
                break;
            }
            case right: {
                replace = new ShowRightReplace(replaceRuler.getReplaceNum(), DesConstants.symbol);
                break;
            }
            case center: {
                replace = new ShowTwoSidesReplace(replaceRuler.getReplaceNum(), DesConstants.symbol);
            }
        }
        return replace;
    }
}

