/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.zbzh;

import cn.gtmap.ai.core.enums.DtZbxEnum;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.ParamException;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DtZbzhUtils {
    private static double PI = Math.PI;
    private static double A = 6378245.0;
    private static double EE = 0.006693421622965943;

    public static String zbzh(String zbjwd, DtZbxEnum sourceZbx, DtZbxEnum targetZbx) {
        if (Objects.isNull(sourceZbx) || Objects.isNull(targetZbx)) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        if (sourceZbx.equals(targetZbx)) {
            return zbjwd;
        }
        if (StringUtils.isBlank((CharSequence)zbjwd)) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        String[] zbjwds = zbjwd.split(",");
        if (zbjwds.length != 2) {
            throw new ParamException(ErrorEnum.PARAM_INCOMPLETE);
        }
        double lon = Double.valueOf(zbjwds[0]);
        double lat = Double.valueOf(zbjwds[1]);
        LonLat lonLat = null;
        if (DtZbzhUtils.isWgsZbx(sourceZbx) && DtZbzhUtils.isGcj(targetZbx)) {
            lonLat = DtZbzhUtils.wgs2gcj(lon, lat);
        } else if (DtZbzhUtils.isGcj(sourceZbx) && DtZbzhUtils.isWgsZbx(targetZbx)) {
            lonLat = DtZbzhUtils.gcj2wgs(lon, lat);
        }
        if (Objects.nonNull(lonLat)) {
            StringBuilder zbjwdBuilder = new StringBuilder();
            zbjwdBuilder.append(lonLat.lon).append(",").append(lonLat.lat);
            return zbjwdBuilder.toString();
        }
        return zbjwd;
    }

    private static boolean isWgsZbx(DtZbxEnum dtZbxEnum) {
        return DtZbxEnum.TDT.equals(dtZbxEnum);
    }

    private static boolean isGcj(DtZbxEnum dtZbxEnum) {
        return DtZbxEnum.AMAP.equals(dtZbxEnum);
    }

    private static boolean outOfChina(double wgLon, double wgLat) {
        return wgLon < 72.004 || wgLon > 137.8347 || wgLat < 0.8293 || wgLat > 55.8271;
    }

    private static LonLat wgs2gcj(double wgLon, double wgLat) {
        if (DtZbzhUtils.outOfChina(wgLon, wgLat)) {
            return new LonLat(wgLon, wgLat);
        }
        double dLat = DtZbzhUtils.transformLats(wgLon - 105.0, wgLat - 35.0);
        double dLon = DtZbzhUtils.transformLons(wgLon - 105.0, wgLat - 35.0);
        double radLat = wgLat / 180.0 * PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - EE * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (A * (1.0 - EE) / (magic * sqrtMagic) * PI);
        dLon = dLon * 180.0 / (A / sqrtMagic * Math.cos(radLat) * PI);
        return new LonLat(wgLon + dLon, wgLat + dLat);
    }

    private static LonLat gcj2wgs(double gclon, double gclat) {
        LonLat d = DtZbzhUtils.deltas(gclat, gclon);
        LonLat mars_point = new LonLat(gclon - d.lon, gclat - d.lat);
        return mars_point;
    }

    private static LonLat deltas(double lon, double lat) {
        double dLat = DtZbzhUtils.transformLats(lon - 105.0, lat - 35.0);
        double dLon = DtZbzhUtils.transformLons(lon - 105.0, lat - 35.0);
        double radLat = lat / 180.0 * PI;
        double magic = Math.sin(radLat);
        magic = 1.0 - EE * magic * magic;
        double sqrtMagic = Math.sqrt(magic);
        dLat = dLat * 180.0 / (A * (1.0 - EE) / (magic * sqrtMagic) * PI);
        dLon = dLon * 180.0 / (A / sqrtMagic * Math.cos(radLat) * PI);
        LonLat lonLat = new LonLat(dLon, dLat);
        return lonLat;
    }

    private static double transformLats(double x, double y) {
        double ret = -100.0 + 2.0 * x + 3.0 * y + 0.2 * y * y + 0.1 * x * y + 0.2 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * PI) + 20.0 * Math.sin(2.0 * x * PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(y * PI) + 40.0 * Math.sin(y / 3.0 * PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(y / 12.0 * PI) + 320.0 * Math.sin(y * PI / 30.0)) * 2.0 / 3.0;
    }

    private static double transformLons(double x, double y) {
        double ret = 300.0 + x + 2.0 * y + 0.1 * x * x + 0.1 * x * y + 0.1 * Math.sqrt(Math.abs(x));
        ret += (20.0 * Math.sin(6.0 * x * PI) + 20.0 * Math.sin(2.0 * x * PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(x * PI) + 40.0 * Math.sin(x / 3.0 * PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(x / 12.0 * PI) + 300.0 * Math.sin(x / 30.0 * PI)) * 2.0 / 3.0;
    }

    static class LonLat {
        private double lon;
        private double lat;

        public LonLat(double lon, double lat) {
            this.lon = lon;
            this.lat = lat;
        }
    }
}

