/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.encryption.sm2;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class Sm2lib {
    private static Logger logger = LoggerFactory.getLogger(Sm2lib.class);
    private static final String TEMP_PUBLIC_KEY = "049613BB58C32CBB679B63C6CE778E4C3A3C794D8C8C89DE255B1298053CB889796DC513663E71C59BE0DB1BF4279F8E500E89A5B51EA37367C3A5D624FDFD831C";
    private static final String TEMP_PRIVATE_KEY = "CF63CDC4BDEF75F8DEF07EC4DE19A5E2B71525C0278A5EC7C8556290B3371535";
    private static final String TEMP_GM_NAMED = "sm2p256v1";
    private static final String TEMP_TAG = "04";
    private static String PUBLIC_KEY;
    private static String PRIVATE_KEY;
    private static String GM_NAMED;
    private static String TAG;

    @Value(value="${encrypt.sm2.publickey: }")
    public void setSm2PublicKey(String sm2PublicKey) {
        PUBLIC_KEY = sm2PublicKey = StringUtils.isBlank((CharSequence)sm2PublicKey) ? TEMP_PUBLIC_KEY : Sm2lib.pzxDecode(sm2PublicKey);
    }

    @Value(value="${encrypt.sm2.privatekey: }")
    public void setSm2PrivateKey(String sm2PrivateKey) {
        PRIVATE_KEY = sm2PrivateKey = StringUtils.isBlank((CharSequence)sm2PrivateKey) ? TEMP_PRIVATE_KEY : Sm2lib.pzxDecode(sm2PrivateKey);
    }

    @Value(value="${encrypt.sm2.named: }")
    public void setSm2Named(String sm2Named) {
        GM_NAMED = sm2Named = StringUtils.isBlank((CharSequence)sm2Named) ? TEMP_GM_NAMED : Sm2lib.pzxDecode(sm2Named);
    }

    @Value(value="${encrypt.sm2.tag: }")
    public void setSm2Tag(String sm2Tag) {
        TAG = sm2Tag = StringUtils.isBlank((CharSequence)sm2Tag) ? TEMP_TAG : Sm2lib.pzxDecode(sm2Tag);
    }

    public static String decode(String cipherData) {
        if (StringUtils.isBlank((CharSequence)cipherData)) {
            return cipherData;
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)cipherData, (CharSequence)TAG)) {
            return cipherData;
        }
        byte[] cipherDataByte = Hex.decode((String)cipherData);
        BigInteger privateKeyD = new BigInteger(PRIVATE_KEY, 16);
        X9ECParameters sm2Parameters = GMNamedCurves.getByName((String)GM_NAMED);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2Parameters.getCurve(), sm2Parameters.getG(), sm2Parameters.getN());
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)privateKeyParameters);
        try {
            byte[] dd = sm2Engine.processBlock(cipherDataByte, 0, cipherDataByte.length);
            byte[] arrayOfBytes = Base64.getDecoder().decode(dd);
            return new String(arrayOfBytes, Charset.forName(String.valueOf(StandardCharsets.UTF_8)));
        }
        catch (InvalidCipherTextException e) {
            logger.error("SM2\u89e3\u5bc6\u5931\u8d25\uff1a", (Throwable)e);
            return cipherData;
        }
    }

    public static String encode(String plaintext) {
        X9ECParameters sm2Parameters = GMNamedCurves.getByName((String)GM_NAMED);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2Parameters.getCurve(), sm2Parameters.getG(), sm2Parameters.getN());
        ECPoint pukPoint = sm2Parameters.getCurve().decodePoint(Hex.decode((String)PUBLIC_KEY));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
        byte[] arrayOfBytes = null;
        try {
            byte[] in = Base64.getEncoder().encode(plaintext.getBytes(StandardCharsets.UTF_8));
            arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
            return Hex.toHexString((byte[])arrayOfBytes);
        }
        catch (Exception e) {
            logger.error("SM2\u52a0\u5bc6\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String encode(String plaintext, String publicKey) {
        X9ECParameters sm2Parameters = GMNamedCurves.getByName((String)GM_NAMED);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2Parameters.getCurve(), sm2Parameters.getG(), sm2Parameters.getN());
        ECPoint pukPoint = sm2Parameters.getCurve().decodePoint(Hex.decode((String)publicKey));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
        byte[] arrayOfBytes = null;
        try {
            byte[] in = Base64.getEncoder().encode(plaintext.getBytes(StandardCharsets.UTF_8));
            arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
            return Hex.toHexString((byte[])arrayOfBytes);
        }
        catch (Exception e) {
            logger.error("SM2\u52a0\u5bc6\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String pzxEncode(String plaintext) {
        X9ECParameters sm2Parameters = GMNamedCurves.getByName((String)TEMP_GM_NAMED);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2Parameters.getCurve(), sm2Parameters.getG(), sm2Parameters.getN());
        ECPoint pukPoint = sm2Parameters.getCurve().decodePoint(Hex.decode((String)TEMP_PUBLIC_KEY));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
        byte[] arrayOfBytes = null;
        try {
            byte[] in = Base64.getEncoder().encode(plaintext.getBytes(StandardCharsets.UTF_8));
            arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
            return Hex.toHexString((byte[])arrayOfBytes);
        }
        catch (Exception e) {
            logger.error("SM2\u52a0\u5bc6\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String pzxDecode(String cipherData) {
        if (StringUtils.isBlank((CharSequence)cipherData)) {
            return cipherData;
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)cipherData, (CharSequence)TEMP_TAG)) {
            return cipherData;
        }
        byte[] cipherDataByte = Hex.decode((String)cipherData);
        BigInteger privateKeyD = new BigInteger(TEMP_PRIVATE_KEY, 16);
        X9ECParameters sm2Parameters = GMNamedCurves.getByName((String)TEMP_GM_NAMED);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2Parameters.getCurve(), sm2Parameters.getG(), sm2Parameters.getN());
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)privateKeyParameters);
        try {
            byte[] dd = sm2Engine.processBlock(cipherDataByte, 0, cipherDataByte.length);
            byte[] arrayOfBytes = Base64.getDecoder().decode(dd);
            return new String(arrayOfBytes, Charset.forName(String.valueOf(StandardCharsets.UTF_8)));
        }
        catch (InvalidCipherTextException e) {
            logger.error("SM2\u89e3\u5bc6\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    static {
        GM_NAMED = TEMP_GM_NAMED;
    }
}

