/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.doc;

import cn.gtmap.ai.core.utils.doc.OfficeUtil;
import cn.gtmap.ai.core.utils.doc.enums.ChartsTypeEnum;
import cn.gtmap.ai.core.utils.doc.model.ChartsData;
import cn.gtmap.ai.core.utils.doc.model.ListData;
import cn.gtmap.ai.core.utils.doc.model.MineLoopRowTableRenderPolicy;
import cn.gtmap.ai.core.utils.doc.model.ParagraphData;
import cn.gtmap.ai.core.utils.doc.model.PictureData;
import cn.gtmap.ai.core.utils.doc.model.SeriesDatas;
import cn.gtmap.ai.core.utils.doc.model.TableDetailData;
import cn.gtmap.ai.core.utils.doc.model.WordExportParam;
import cn.gtmap.ai.core.utils.doc.model.WordItems;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.config.Configure;
import com.deepoove.poi.config.ConfigureBuilder;
import com.deepoove.poi.data.ChartSingleSeriesRenderData;
import com.deepoove.poi.data.Charts;
import com.deepoove.poi.data.HyperlinkTextRenderData;
import com.deepoove.poi.data.NumberingFormat;
import com.deepoove.poi.data.Numberings;
import com.deepoove.poi.data.PictureType;
import com.deepoove.poi.data.Pictures;
import com.deepoove.poi.data.SeriesRenderData;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.xwpf.NumFormat;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WordProcessUtil {
    private static final Logger log = LoggerFactory.getLogger(WordProcessUtil.class);

    public static byte[] exportWord(WordExportParam wordExportParam) {
        HashMap dataMap = Maps.newHashMap();
        ConfigureBuilder configureBuilder = Configure.builder().useSpringEL();
        WordProcessUtil.wordParamProcess(dataMap, configureBuilder, wordExportParam.getWordItems(), null);
        Configure config = configureBuilder.build();
        String resource = wordExportParam.getTemplateSource();
        Calendar now = Calendar.getInstance();
        dataMap.put("y", now.get(1));
        dataMap.put("m", now.get(2) + 1);
        dataMap.put("d", now.get(5));
        byte[] bytes = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             XWPFTemplate template = XWPFTemplate.compile((String)resource, (Configure)config).render((Object)dataMap);){
            template.write((OutputStream)out);
            bytes = out.toByteArray();
        }
        catch (Exception e) {
            log.error("exportWord - Exception:", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return bytes;
    }

    public static byte[] exportPdf(WordExportParam wordExportParam) {
        byte[] data = WordProcessUtil.exportWord(wordExportParam);
        return OfficeUtil.saveDocxToPDF(data);
    }

    private static void wordParamProcess(HashMap dataMap, ConfigureBuilder configureBuilder, WordItems wordItems, String groupName) {
        if (null != wordItems) {
            if (CollectionUtils.isNotEmpty(wordItems.getTabeList())) {
                WordProcessUtil.tableProcess(dataMap, configureBuilder, wordItems.getTabeList(), groupName);
            }
            if (CollectionUtils.isNotEmpty(wordItems.getChartsList())) {
                WordProcessUtil.chartsProcess(dataMap, wordItems.getChartsList(), groupName);
            }
            if (CollectionUtils.isNotEmpty(wordItems.getTextDatas())) {
                WordProcessUtil.paragraphProcess(dataMap, wordItems.getTextDatas(), groupName);
            }
            if (CollectionUtils.isNotEmpty(wordItems.getPictureDatas())) {
                WordProcessUtil.pictureProcess(dataMap, wordItems.getPictureDatas(), groupName);
            }
            if (CollectionUtils.isNotEmpty(wordItems.getListDatas())) {
                WordProcessUtil.listProcess(dataMap, wordItems.getListDatas(), groupName);
            }
        }
        if (MapUtils.isNotEmpty(wordItems.getWordItemsGroup())) {
            for (Map.Entry<String, WordItems> wordExportParamEntry : wordItems.getWordItemsGroup().entrySet()) {
                WordProcessUtil.wordParamProcess(dataMap, configureBuilder, wordExportParamEntry.getValue(), wordExportParamEntry.getKey());
            }
        }
    }

    private static void chartsProcess(HashMap data, List<ChartsData> chartsDataList, String groupName) {
        List chartsMapList;
        boolean hasGroup = StringUtils.isNotBlank((CharSequence)groupName);
        List list = chartsMapList = hasGroup ? (List)MapUtils.getObject((Map)data, (Object)groupName, (Object)Lists.newArrayList()) : null;
        if (CollectionUtils.isNotEmpty(chartsDataList)) {
            for (int i = 0; i < chartsDataList.size(); ++i) {
                ChartsData chartsData = chartsDataList.get(i);
                HashMap chartsMap = WordProcessUtil.getCharts(chartsData);
                if (hasGroup) {
                    if (chartsMapList.size() > i) {
                        ((HashMap)chartsMapList.get(i)).putAll(chartsMap);
                        continue;
                    }
                    chartsMapList.add(chartsMap);
                    continue;
                }
                data.putAll(chartsMap);
            }
        }
        if (hasGroup) {
            data.put(groupName, chartsMapList);
        }
    }

    private static HashMap getCharts(ChartsData chartsData) {
        HashMap map = Maps.newHashMap();
        if (MapUtils.isNotEmpty(chartsData.getSeriesDatas()) && CollectionUtils.isNotEmpty(chartsData.getCategories())) {
            Map<String, SeriesDatas> seriesDatasMap = chartsData.getSeriesDatas();
            String[] categories = chartsData.getCategories().toArray(new String[chartsData.getCategories().size()]);
            ChartSingleSeriesRenderData barCharts = null;
            ChartsTypeEnum chartsTypeEnum = chartsData.getChartsTypeEnum();
            if (null != chartsTypeEnum.getType()) {
                if (StringUtils.equals((CharSequence)"1", (CharSequence)chartsTypeEnum.getType())) {
                    Charts.ChartSingles chart = Charts.ofSingleSeries((String)chartsData.getTitle(), (String[])categories);
                    for (Map.Entry<String, SeriesDatas> seriesDatasEntry : seriesDatasMap.entrySet()) {
                        SeriesDatas seriesDatas = seriesDatasEntry.getValue();
                        if (!CollectionUtils.isNotEmpty(seriesDatas.getDatas())) continue;
                        chart.series(seriesDatasEntry.getKey(), seriesDatas.getDatas().toArray(new Number[seriesDatas.getDatas().size()]));
                    }
                    barCharts = chart.create();
                } else if (StringUtils.equals((CharSequence)"2", (CharSequence)chartsTypeEnum.getType())) {
                    Charts.ChartMultis chart = Charts.ofMultiSeries((String)chartsData.getTitle(), (String[])categories);
                    for (Map.Entry<String, SeriesDatas> seriesDatasEntry : seriesDatasMap.entrySet()) {
                        SeriesDatas seriesDatas = seriesDatasEntry.getValue();
                        if (!CollectionUtils.isNotEmpty(seriesDatas.getDatas())) continue;
                        chart.addSeries(seriesDatasEntry.getKey(), seriesDatas.getDatas().toArray(new Number[seriesDatas.getDatas().size()]));
                    }
                    barCharts = chart.create();
                } else if (StringUtils.equals((CharSequence)"3", (CharSequence)chartsTypeEnum.getType())) {
                    Charts.ChartCombos chart = Charts.ofComboSeries((String)chartsData.getTitle(), (String[])categories);
                    for (Map.Entry<String, SeriesDatas> seriesDatasEntry : seriesDatasMap.entrySet()) {
                        SeriesDatas seriesDatas = seriesDatasEntry.getValue();
                        if (!CollectionUtils.isNotEmpty(seriesDatas.getDatas())) continue;
                        if (seriesDatas.getType().getType().equals((Object)SeriesRenderData.ComboType.BAR)) {
                            chart.addBarSeries(seriesDatasEntry.getKey(), seriesDatas.getDatas().toArray(new Number[seriesDatas.getDatas().size()]));
                            continue;
                        }
                        if (seriesDatas.getType().getType().equals((Object)SeriesRenderData.ComboType.LINE)) {
                            chart.addLineSeries(seriesDatasEntry.getKey(), seriesDatas.getDatas().toArray(new Number[seriesDatas.getDatas().size()]));
                            continue;
                        }
                        chart.addAreaSeries(seriesDatasEntry.getKey(), seriesDatas.getDatas().toArray(new Number[seriesDatas.getDatas().size()]));
                    }
                    barCharts = chart.create();
                }
            }
            map.put(chartsData.getChartName(), barCharts);
        }
        return map;
    }

    private static void paragraphProcess(HashMap data, List<ParagraphData> paragraphDataList, String groupName) {
        boolean hasGroup = StringUtils.isNotBlank((CharSequence)groupName);
        if (CollectionUtils.isNotEmpty(paragraphDataList)) {
            if (hasGroup) {
                List mapList = (List)MapUtils.getObject((Map)data, (Object)groupName, (Object)Lists.newArrayList());
                for (int i = 0; i < paragraphDataList.size(); ++i) {
                    ParagraphData paragraphData = paragraphDataList.get(i);
                    HashMap map = Maps.newHashMap();
                    if (StringUtils.isNotBlank((CharSequence)paragraphData.getHyperLink())) {
                        map.put(paragraphData.getName(), new HyperlinkTextRenderData(paragraphData.getValue(), paragraphData.getHyperLink()));
                    } else if (StringUtils.isNotBlank((CharSequence)paragraphData.getAnchor())) {
                        map.put(paragraphData.getName(), new HyperlinkTextRenderData(paragraphData.getValue(), "anchor:" + paragraphData.getHyperLink()));
                    } else {
                        map.put(paragraphData.getName(), paragraphData.getValue());
                    }
                    if (mapList.size() > i) {
                        ((HashMap)mapList.get(i)).putAll(map);
                        continue;
                    }
                    mapList.add(map);
                }
                data.put(groupName, mapList);
            } else {
                for (ParagraphData paragraphData : paragraphDataList) {
                    if (StringUtils.isNotBlank((CharSequence)paragraphData.getHyperLink())) {
                        data.put(paragraphData.getName(), new HyperlinkTextRenderData(paragraphData.getValue(), paragraphData.getHyperLink()));
                        continue;
                    }
                    if (StringUtils.isNotBlank((CharSequence)paragraphData.getAnchor())) {
                        data.put(paragraphData.getName(), new HyperlinkTextRenderData(paragraphData.getValue(), "anchor:" + paragraphData.getHyperLink()));
                        continue;
                    }
                    data.put(paragraphData.getName(), paragraphData.getValue());
                }
            }
        }
    }

    private static void pictureProcess(HashMap data, List<PictureData> pictureDataList, String groupName) {
        boolean hasGroup = StringUtils.isNotBlank((CharSequence)groupName);
        if (CollectionUtils.isNotEmpty(pictureDataList)) {
            if (hasGroup) {
                List mapList = (List)MapUtils.getObject((Map)data, (Object)groupName, (Object)Lists.newArrayList());
                for (int i = 0; i < pictureDataList.size(); ++i) {
                    HashMap map = WordProcessUtil.getPicture(pictureDataList.get(i));
                    if (mapList.size() > i) {
                        ((HashMap)mapList.get(i)).putAll(map);
                        continue;
                    }
                    mapList.add(map);
                }
                data.put(groupName, mapList);
            } else {
                for (PictureData pictureData : pictureDataList) {
                    HashMap map = WordProcessUtil.getPicture(pictureData);
                    data.putAll(map);
                }
            }
        }
    }

    private static HashMap getPicture(PictureData pictureData) {
        HashMap map = Maps.newHashMap();
        String pictureName = pictureData.getName();
        Pictures.PictureBuilder pictureBuilder = null;
        if (StringUtils.isNotBlank((CharSequence)pictureData.getPath())) {
            pictureBuilder = Pictures.ofLocal((String)pictureData.getPath());
        } else if (StringUtils.isNotBlank((CharSequence)pictureData.getUrl())) {
            pictureBuilder = null != pictureData.getPictureType() ? Pictures.ofUrl((String)pictureData.getUrl(), (PictureType)pictureData.getPictureType()) : Pictures.ofUrl((String)pictureData.getUrl());
        } else if (null != pictureData.getImage() && null != pictureData.getPictureType()) {
            pictureBuilder = Pictures.ofBufferedImage((BufferedImage)pictureData.getImage(), (PictureType)pictureData.getPictureType());
        } else if (null != pictureData.getStream()) {
            pictureBuilder = null != pictureData.getPictureType() ? Pictures.ofStream((InputStream)pictureData.getStream(), (PictureType)pictureData.getPictureType()) : Pictures.ofStream((InputStream)pictureData.getStream());
        } else if (null != pictureData.getBase64() && null != pictureData.getPictureType()) {
            pictureBuilder = Pictures.ofBase64((String)pictureData.getBase64(), (PictureType)pictureData.getPictureType());
        } else if (null != pictureData.getBytes()) {
            pictureBuilder = null != pictureData.getPictureType() ? Pictures.ofBytes((byte[])pictureData.getBytes(), (PictureType)pictureData.getPictureType()) : Pictures.ofBytes((byte[])pictureData.getBytes());
        }
        if (null != pictureBuilder && pictureData.getHeight() > 0 && pictureData.getWidth() > 0) {
            pictureBuilder.size(pictureData.getWidth(), pictureData.getHeight());
        }
        if (null != pictureBuilder) {
            map.put(pictureName, pictureBuilder.create());
        }
        return map;
    }

    private static void tableProcess(HashMap data, ConfigureBuilder configureBuilder, List<TableDetailData> tableDetailDataList, String groupName) {
        boolean hasGroup = StringUtils.isNotBlank((CharSequence)groupName);
        if (CollectionUtils.isNotEmpty(tableDetailDataList)) {
            MineLoopRowTableRenderPolicy policy = new MineLoopRowTableRenderPolicy();
            if (hasGroup) {
                List mapList = (List)MapUtils.getObject((Map)data, (Object)groupName, (Object)Lists.newArrayList());
                for (int i = 0; i < tableDetailDataList.size(); ++i) {
                    TableDetailData tableDetailData = tableDetailDataList.get(i);
                    HashMap map = Maps.newHashMap();
                    configureBuilder.bind(tableDetailData.getTableName(), (RenderPolicy)policy);
                    if (CollectionUtils.isNotEmpty(tableDetailData.getTableTextDatas())) {
                        WordProcessUtil.paragraphProcess(map, tableDetailData.getTableTextDatas(), null);
                    }
                    map.put(tableDetailData.getTableName(), tableDetailData);
                    if (mapList.size() > i) {
                        ((HashMap)mapList.get(i)).putAll(map);
                        continue;
                    }
                    mapList.add(map);
                }
                data.put(groupName, mapList);
            } else {
                for (TableDetailData tableDetailData : tableDetailDataList) {
                    configureBuilder.bind(tableDetailData.getTableName(), (RenderPolicy)policy);
                    data.put(tableDetailData.getTableName(), tableDetailData);
                    if (!CollectionUtils.isNotEmpty(tableDetailData.getTableTextDatas())) continue;
                    WordProcessUtil.paragraphProcess(data, tableDetailData.getTableTextDatas(), groupName);
                }
            }
        }
    }

    private static void listProcess(HashMap data, List<ListData> listDatas, String groupName) {
        boolean hasGroup = StringUtils.isNotBlank((CharSequence)groupName);
        if (CollectionUtils.isNotEmpty(listDatas)) {
            if (hasGroup) {
                List mapList = (List)MapUtils.getObject((Map)data, (Object)groupName, (Object)Lists.newArrayList());
                for (int i = 0; i < listDatas.size(); ++i) {
                    ListData listData = listDatas.get(i);
                    if (mapList.size() > i) {
                        ((HashMap)mapList.get(i)).put(listData.getName(), WordProcessUtil.getNumberingRenderData(listData));
                        continue;
                    }
                    HashMap map = Maps.newHashMap();
                    map.put(listData.getName(), WordProcessUtil.getNumberingRenderData(listData));
                    mapList.add(map);
                }
                data.put(groupName, mapList);
            } else {
                for (ListData listData : listDatas) {
                    data.put(listData.getName(), WordProcessUtil.getNumberingRenderData(listData));
                }
            }
        }
    }

    private static Object getNumberingRenderData(ListData listData) {
        Numberings.NumberingBuilder builder;
        if (StringUtils.isNotBlank((CharSequence)listData.getCustomTag())) {
            builder = Numberings.of((NumberingFormat)new NumberingFormat(NumFormat.BULLET, listData.getCustomTag()));
        } else if (null == listData.getFormat()) {
            builder = Numberings.of((NumberingFormat)NumberingFormat.DECIMAL);
        } else {
            NumberingFormat numFormat = listData.getFormat().getFomat();
            builder = Numberings.of((NumberingFormat)numFormat);
        }
        for (String data : listData.getDatas()) {
            builder.addItem(data);
        }
        return builder.create();
    }
}

