/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.storage.application.impl;

import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.enums.FileTypeEnum;
import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.exception.ParamException;
import cn.gtmap.ai.core.exception.PzxException;
import cn.gtmap.ai.core.service.storage.application.StorageService;
import cn.gtmap.ai.core.service.storage.domain.MultiPartModel;
import cn.gtmap.ai.core.service.storage.domain.StorageModel;
import cn.gtmap.ai.core.service.storage.domain.bo.gtcloud.GtCloudStorageFolderBo;
import cn.gtmap.ai.core.service.storage.domain.bo.gtcloud.GtCloudStorageMultiBo;
import cn.gtmap.ai.core.service.storage.domain.bo.gtcloud.GtCloudStorageQueryBo;
import cn.gtmap.ai.core.service.storage.dto.StorageDto;
import cn.gtmap.ai.core.service.storage.infrastructure.convert.GtcMultiPartConvert;
import cn.gtmap.ai.core.service.storage.infrastructure.convert.GtcStorageConverter;
import cn.gtmap.ai.core.service.token.application.AiXtJkglModelService;
import cn.gtmap.ai.core.service.token.domian.model.JkglModel;
import cn.gtmap.ai.core.service.token.query.JkglQuery;
import cn.gtmap.ai.core.utils.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.gtis.common.util.UUIDGenerator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;

@Service(value="gtcloudStorageServiceImpl")
public class GtCloudStorageServiceImpl
implements StorageService {
    private static final Logger logger = LoggerFactory.getLogger(GtCloudStorageServiceImpl.class);
    private static final String STORAGE_LIST_JKGJZ = "gtcloud.storage.list.url";
    private static final String STORAGE_NEWFOLDER_JKGJZ = "gtcloud.storage.newfolder.url";
    private static final String STORAGE_UPLOAD_JKGJZ = "gtcloud.storage.upload.url";
    @Autowired
    private AiXtJkglModelService aiXtJkglModelService;
    @Autowired
    private HttpUtil httpUtil;

    @Override
    public StorageModel uploadFile(MultiPartModel multiPartModel) {
        StorageModel folderStorageModel;
        if (StringUtils.isBlank((CharSequence)multiPartModel.getParentFolderNodeId()) && CollectionUtils.isEmpty(multiPartModel.getFolderNameList()) || Objects.isNull(multiPartModel.getData())) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        GtCloudStorageMultiBo multiBo = new GtCloudStorageMultiBo();
        if (CollectionUtils.isNotEmpty(multiPartModel.getFolderNameList()) && Objects.nonNull(folderStorageModel = this.createFolder(multiPartModel))) {
            multiBo.setNodeId(folderStorageModel.getId());
        }
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setQydm("000000");
        jkglQuery.setJkgjz(STORAGE_UPLOAD_JKGJZ);
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        if (StringUtils.isBlank((CharSequence)jkglModel.getJkdz())) {
            throw new PzxException("\u5927\u4e91\u9644\u4ef6\u4e0a\u4f20: " + jkglQuery.getJkgjz() + "\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5!");
        }
        multiBo.setRename(multiPartModel.getRename());
        multiBo.setClientId(multiPartModel.getClientId());
        multiBo.setSpaceId(multiPartModel.getAppId());
        String url = jkglModel.getJkdz();
        try {
            url = url + "?spaceId=" + multiBo.getSpaceId() + "&nodeId=" + multiBo.getNodeId() + "&clientId=" + (StringUtils.isNotBlank((CharSequence)multiBo.getClientId()) ? multiBo.getClientId() : "") + "&rename=" + multiBo.getRename() + "&rename=" + multiBo.getRename();
            String result = HttpUtil.sendPostFileRequest(url, null, "file", multiPartModel.getData(), multiPartModel.getOriginalFilename(), null);
            List storageDtoList = JSONArray.parseArray((String)result, StorageDto.class);
            List<StorageModel> modelList = GtcStorageConverter.INSTANCE.toStorageModelList(storageDtoList);
            return this.filterStorageModelList(modelList, multiPartModel.getOriginalFilename());
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u529f\u80fd\u5f02\u5e38\uff1a", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public StorageModel createFolder(MultiPartModel multiPartModel) {
        StorageModel storageModel;
        if (CollectionUtils.isEmpty(multiPartModel.getFolderNameList()) || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{multiPartModel.getAppId()})) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        List<StorageModel> modelList = this.queryFjxx(multiPartModel);
        if (CollectionUtils.isNotEmpty(modelList) && Objects.nonNull(storageModel = this.filterStorageModelList(modelList, multiPartModel.getFolderNameList().get(0)))) {
            return storageModel;
        }
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setQydm("000000");
        jkglQuery.setJkgjz(STORAGE_NEWFOLDER_JKGJZ);
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        if (StringUtils.isBlank((CharSequence)jkglModel.getJkdz())) {
            throw new PzxException("\u5927\u4e91\u9644\u4ef6\u76ee\u5f55\u521b\u5efa: " + jkglQuery.getJkgjz() + "\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5!");
        }
        GtCloudStorageFolderBo folderBo = GtcMultiPartConvert.INSTANCE.toFolderBo(multiPartModel);
        folderBo.setAccessToken(jkglModel.getToken());
        folderBo.setClientId(StringUtils.isNotBlank((CharSequence)multiPartModel.getClientId()) ? multiPartModel.getClientId() : "");
        folderBo.setNodeId(StringUtils.isNotBlank((CharSequence)multiPartModel.getParentFolderNodeId()) ? multiPartModel.getParentFolderNodeId() : "");
        ParameterizedTypeReference<List<StorageDto>> typeRef = new ParameterizedTypeReference<List<StorageDto>>(){};
        List<StorageDto> storageDtoList = this.httpUtil.getPostUrlData(JSONObject.parseObject((String)JSON.toJSONString((Object)folderBo)), jkglModel.getJkdz(), typeRef, jkglModel.getJkgjz(), UUIDGenerator.generate18(), null);
        if (CollectionUtils.isNotEmpty(storageDtoList)) {
            return GtcStorageConverter.INSTANCE.toStorageModel(storageDtoList.get(0));
        }
        return null;
    }

    @Override
    public MultiPartModel downLoadNode(MultiPartModel multiPartModel) {
        return null;
    }

    @Override
    public List<StorageModel> queryFjxx(MultiPartModel multiPartModel) {
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setQydm("000000");
        jkglQuery.setJkgjz(STORAGE_LIST_JKGJZ);
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        if (StringUtils.isBlank((CharSequence)jkglModel.getJkdz())) {
            throw new PzxException("\u5927\u4e91\u9644\u4ef6\u4fe1\u606f\u83b7\u53d6: " + jkglQuery.getJkgjz() + "\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5!");
        }
        GtCloudStorageQueryBo queryBo = new GtCloudStorageQueryBo();
        queryBo.setSpaceId(multiPartModel.getAppId());
        queryBo.setAccessToken(jkglModel.getToken());
        queryBo.setClientId(StringUtils.isNotBlank((CharSequence)multiPartModel.getClientId()) ? multiPartModel.getClientId() : "");
        queryBo.setNodeId(StringUtils.isNotBlank((CharSequence)multiPartModel.getCurrentNodeId()) ? multiPartModel.getCurrentNodeId() : "");
        ParameterizedTypeReference<List<StorageDto>> typeRef = new ParameterizedTypeReference<List<StorageDto>>(){};
        List<StorageDto> storageDtoList = this.httpUtil.getGetData(JSONObject.parseObject((String)JSON.toJSONString((Object)queryBo)), jkglModel.getJkdz(), typeRef, jkglModel.getJkgjz(), UUIDGenerator.generate18(), null);
        return GtcStorageConverter.INSTANCE.toStorageModelList(storageDtoList);
    }

    @Override
    public void showFile(MultiPartModel multiPartModel, HttpServletResponse httpServletResponse) {
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setQydm("000000");
        jkglQuery.setJkgjz(STORAGE_LIST_JKGJZ);
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        if (StringUtils.isBlank((CharSequence)jkglModel.getJkdz())) {
            throw new PzxException("\u5927\u4e91\u9644\u4ef6\u4fe1\u606f\u83b7\u53d6: " + jkglQuery.getJkgjz() + "\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5!");
        }
        GtCloudStorageQueryBo queryBo = new GtCloudStorageQueryBo();
        queryBo.setSpaceId("");
        queryBo.setAccessToken(jkglModel.getToken());
        queryBo.setClientId("");
        queryBo.setNodeId(multiPartModel.getCurrentNodeId());
        ParameterizedTypeReference<List<StorageDto>> typeRef = new ParameterizedTypeReference<List<StorageDto>>(){};
        List<StorageDto> storageDtoList = this.httpUtil.getGetData(JSONObject.parseObject((String)JSON.toJSONString((Object)queryBo)), jkglModel.getJkdz(), typeRef, jkglModel.getJkgjz(), UUIDGenerator.generate18(), null);
        StorageDto storageDto = this.filterStorageDtoList(storageDtoList, multiPartModel.getCurrentNodeId());
        if (Objects.isNull(storageDto)) {
            throw new BizException(ErrorEnum.FJ_FILE_NOTEXISTS);
        }
        this.fileOutput(multiPartModel.isSfxz(), storageDto, httpServletResponse);
    }

    private StorageDto filterStorageDtoList(List<StorageDto> dtoList, String nodeId) {
        if (CollectionUtils.isNotEmpty(dtoList)) {
            for (StorageDto storageDto : dtoList) {
                if (!StringUtils.equals((CharSequence)storageDto.getId(), (CharSequence)nodeId) && CollectionUtils.isNotEmpty(storageDto.getChildren())) {
                    StorageDto storageDto2 = this.filterStorageDtoList(storageDto.getChildren(), nodeId);
                    if (!Objects.nonNull(storageDto2)) continue;
                    return storageDto2;
                }
                if (!StringUtils.equals((CharSequence)storageDto.getId(), (CharSequence)nodeId)) continue;
                if (StringUtils.endsWith((CharSequence)storageDto.getName(), (CharSequence)".pdf")) {
                    storageDto.setType(FileTypeEnum.DOC.getType());
                }
                return storageDto;
            }
        }
        return null;
    }

    private StorageModel filterStorageModelList(List<StorageModel> modelList, String name) {
        if (CollectionUtils.isNotEmpty(modelList)) {
            for (StorageModel storageModel : modelList) {
                if (!StringUtils.equals((CharSequence)storageModel.getName(), (CharSequence)name) && CollectionUtils.isNotEmpty(storageModel.getChildren())) {
                    StorageModel storageModel2 = this.filterStorageModelList(storageModel.getChildren(), name);
                    if (!Objects.nonNull(storageModel2)) continue;
                    return storageModel2;
                }
                if (!StringUtils.equals((CharSequence)storageModel.getName(), (CharSequence)name)) continue;
                if (StringUtils.endsWith((CharSequence)storageModel.getName(), (CharSequence)".pdf")) {
                    storageModel.setFileType(FileTypeEnum.DOC);
                }
                return storageModel;
            }
        }
        return null;
    }

    private void fileOutput(boolean sfxz, StorageDto storageDto, HttpServletResponse httpServletResponse) {
        String contentType = storageDto.getFileType();
        if (StringUtils.endsWith((CharSequence)storageDto.getName(), (CharSequence)".pdf")) {
            contentType = "application/pdf";
        }
        if (StringUtils.isNotBlank((CharSequence)contentType)) {
            httpServletResponse.setContentType(contentType);
        } else {
            httpServletResponse.setContentType("image/jpeg;image/png;");
        }
        try (ServletOutputStream outputStream = httpServletResponse.getOutputStream();
             ByteArrayInputStream in = new ByteArrayInputStream(HttpUtil.dwonlaodFile(storageDto.getDownUrl()));){
            String filename = URLEncoder.encode(storageDto.getName(), "UTF-8");
            if (sfxz) {
                httpServletResponse.setHeader("Content-Disposition", "attachment;filename=" + filename);
            }
            byte[] buffer = new byte[1024];
            int i = -1;
            while ((i = in.read(buffer)) != -1) {
                outputStream.write(buffer, 0, i);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

