/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.sign.infrastructure;

import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.ParamException;
import cn.gtmap.ai.core.service.sign.domain.model.AiXtQsrwModel;
import cn.gtmap.ai.core.service.sign.domain.repository.AiXtQsrwRepository;
import cn.gtmap.ai.core.service.sign.dto.AiXtQsrwSaveDto;
import cn.gtmap.ai.core.service.sign.infrastructure.convert.AiXtQsrwPOConvert;
import cn.gtmap.ai.core.service.sign.infrastructure.mapper.AiXtQsrwMapper;
import cn.gtmap.ai.core.service.sign.infrastructure.po.AiXtQsrwPo;
import cn.gtmap.ai.core.service.sign.query.SignQuery;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.gtis.common.util.UUIDGenerator;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class AiXtQsrwRepositoryImpl
extends ServiceImpl<AiXtQsrwMapper, AiXtQsrwPo>
implements AiXtQsrwRepository,
IService<AiXtQsrwPo> {
    @Override
    public AiXtQsrwModel getQsrw(SignQuery signQuery) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)signQuery.getQsrwid())) {
            queryWrapper.eq((Object)"qsrwid", (Object)signQuery.getQsrwid());
        }
        if (StringUtils.isNotBlank((CharSequence)signQuery.getLsh())) {
            queryWrapper.eq((Object)"lsh", (Object)signQuery.getLsh());
        }
        if (StringUtils.isNotBlank((CharSequence)signQuery.getSlbh())) {
            queryWrapper.eq((Object)"slbh", (Object)signQuery.getSlbh());
        }
        if (queryWrapper.isEmptyOfWhere()) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        return AiXtQsrwPOConvert.INSTANCE.poToMdeol((AiXtQsrwPo)this.getOne((Wrapper)queryWrapper, false));
    }

    @Override
    public List<AiXtQsrwModel> queryQsrw(SignQuery signQuery) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)signQuery.getQsrwid())) {
            queryWrapper.eq((Object)"qsrwid", (Object)signQuery.getQsrwid());
        }
        if (StringUtils.isNotBlank((CharSequence)signQuery.getLsh())) {
            queryWrapper.eq((Object)"lsh", (Object)signQuery.getLsh());
        }
        if (StringUtils.isNotBlank((CharSequence)signQuery.getSlbh())) {
            queryWrapper.eq((Object)"slbh", (Object)signQuery.getSlbh());
        }
        if (queryWrapper.isEmptyOfWhere()) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        return AiXtQsrwPOConvert.INSTANCE.poToMdeolList(((AiXtQsrwMapper)this.baseMapper).selectList((Wrapper)queryWrapper));
    }

    @Override
    public boolean insertQsrw(AiXtQsrwSaveDto dto) {
        AiXtQsrwPo po = AiXtQsrwPOConvert.INSTANCE.saveDtoToPo(dto);
        if (Objects.nonNull(po)) {
            if (StringUtils.isBlank((CharSequence)po.getQsrwid())) {
                po.setQsrwid(UUIDGenerator.generate18());
            }
            return this.save(po);
        }
        return false;
    }

    @Override
    public boolean updateQsrw(AiXtQsrwSaveDto dto) {
        AiXtQsrwPo po = AiXtQsrwPOConvert.INSTANCE.saveDtoToPo(dto);
        if (Objects.nonNull(po) && StringUtils.isNotBlank((CharSequence)po.getQsrwid())) {
            AiXtQsrwPo oldPo = (AiXtQsrwPo)((AiXtQsrwMapper)this.baseMapper).selectById((Serializable)((Object)po.getQsrwid()));
            oldPo.setQssbyy(po.getQssbyy());
            oldPo.setQszt(po.getQszt());
            return this.updateById(oldPo);
        }
        return false;
    }
}

