/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.sign.infrastructure;

import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.ParamException;
import cn.gtmap.ai.core.service.sign.domain.model.AiXtQsrwQsrModel;
import cn.gtmap.ai.core.service.sign.domain.repository.AiXtQsrwQsrRepository;
import cn.gtmap.ai.core.service.sign.dto.AiXtQsrwQsrSaveDto;
import cn.gtmap.ai.core.service.sign.infrastructure.convert.AiXtQsrwQsrPOConvert;
import cn.gtmap.ai.core.service.sign.infrastructure.mapper.AiXtQsrwQsrMapper;
import cn.gtmap.ai.core.service.sign.infrastructure.po.AiXtQsrwQsrPo;
import cn.gtmap.ai.core.service.sign.query.SignQuery;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Maps;
import com.gtis.common.util.UUIDGenerator;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class AiXtQsrwQsrRepositoryImpl
extends ServiceImpl<AiXtQsrwQsrMapper, AiXtQsrwQsrPo>
implements AiXtQsrwQsrRepository,
IService<AiXtQsrwQsrPo> {
    @Override
    public List<AiXtQsrwQsrModel> queryQsr(SignQuery signQuery) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)signQuery.getQsrwid())) {
            queryWrapper.eq((Object)"qsrwid", (Object)signQuery.getQsrwid());
        }
        if (StringUtils.isNotBlank((CharSequence)signQuery.getLsh())) {
            queryWrapper.eq((Object)"lsh", (Object)signQuery.getLsh());
        }
        if (StringUtils.isNotBlank((CharSequence)signQuery.getSlbh())) {
            queryWrapper.eq((Object)"slbh", (Object)signQuery.getSlbh());
        }
        if (queryWrapper.isEmptyOfWhere()) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        return AiXtQsrwQsrPOConvert.INSTANCE.poToMdeolList(((AiXtQsrwQsrMapper)this.baseMapper).selectList((Wrapper)queryWrapper));
    }

    @Override
    public boolean insertQsrBacth(List<AiXtQsrwQsrSaveDto> dtoList) {
        List<AiXtQsrwQsrPo> poList = AiXtQsrwQsrPOConvert.INSTANCE.saveDtoToPoList(dtoList);
        if (CollectionUtils.isNotEmpty(poList)) {
            poList.forEach(po -> {
                if (StringUtils.isBlank((CharSequence)po.getQsrid())) {
                    po.setQsrid(UUIDGenerator.generate18());
                }
            });
            return this.saveBatch(poList);
        }
        return false;
    }

    @Override
    public List<AiXtQsrwQsrModel> updateQsrBacth(List<AiXtQsrwQsrSaveDto> dtoList) {
        List<AiXtQsrwQsrPo> poList = AiXtQsrwQsrPOConvert.INSTANCE.saveDtoToPoList(dtoList);
        if (CollectionUtils.isNotEmpty(poList)) {
            HashMap qsrwQsrPoMap = Maps.newHashMap();
            poList.forEach(po -> qsrwQsrPoMap.put(po.getZjh(), po));
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"qsrwid", (Object)poList.get(0).getQsrwid());
            List oldPoList = ((AiXtQsrwQsrMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
            for (AiXtQsrwQsrPo aiXtQsrwQsrPo : oldPoList) {
                AiXtQsrwQsrPo po2 = (AiXtQsrwQsrPo)qsrwQsrPoMap.get(aiXtQsrwQsrPo.getZjh());
                aiXtQsrwQsrPo.setQszt(po2.getQszt());
                aiXtQsrwQsrPo.setQssbyy(po2.getQssbyy());
            }
            this.updateBatchById(oldPoList);
            return AiXtQsrwQsrPOConvert.INSTANCE.poToMdeolList(oldPoList);
        }
        return null;
    }
}

