/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.sign.application;

import cn.gtmap.ai.core.constant.ComponentConstants;
import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.enums.WjQsztEnum;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.sign.domain.bo.SignCreateBO;
import cn.gtmap.ai.core.service.sign.domain.bo.SignFjxx;
import cn.gtmap.ai.core.service.sign.domain.bo.SignQsrxx;
import cn.gtmap.ai.core.service.sign.domain.bo.SignQsrxxQswj;
import cn.gtmap.ai.core.service.sign.domain.convert.AiXtQsrwQsrDtoConvert;
import cn.gtmap.ai.core.service.sign.domain.convert.SignConvert;
import cn.gtmap.ai.core.service.sign.domain.model.AiXtQsrwFjxxModel;
import cn.gtmap.ai.core.service.sign.domain.model.AiXtQsrwQsrFjxxRelModel;
import cn.gtmap.ai.core.service.sign.domain.model.AiXtQsrwQsrModel;
import cn.gtmap.ai.core.service.sign.domain.repository.AiXtQsrwFjxxRepository;
import cn.gtmap.ai.core.service.sign.domain.repository.AiXtQsrwQsrFjxxRelRepository;
import cn.gtmap.ai.core.service.sign.domain.repository.AiXtQsrwQsrRepository;
import cn.gtmap.ai.core.service.sign.domain.repository.AiXtQsrwRepository;
import cn.gtmap.ai.core.service.sign.dto.AiXtQsrwFjxxSaveDto;
import cn.gtmap.ai.core.service.sign.dto.AiXtQsrwQsrDto;
import cn.gtmap.ai.core.service.sign.dto.AiXtQsrwQsrFjxxRelSaveDto;
import cn.gtmap.ai.core.service.sign.dto.AiXtQsrwQsrSaveDto;
import cn.gtmap.ai.core.service.sign.dto.AiXtQsrwSaveDto;
import cn.gtmap.ai.core.service.sign.dto.sign.SignFjxxDto;
import cn.gtmap.ai.core.service.sign.dto.sign.SignJrcsDto;
import cn.gtmap.ai.core.service.sign.dto.sign.SignResponseDataQsrxxDto;
import cn.gtmap.ai.core.service.sign.dto.sign.SignResponseDto;
import cn.gtmap.ai.core.service.sign.dto.signhd.SignHdResponseDto;
import cn.gtmap.ai.core.service.sign.query.SignQuery;
import cn.gtmap.ai.core.service.storage.application.StorageService;
import cn.gtmap.ai.core.service.storage.domain.MultiPartModel;
import cn.gtmap.ai.core.service.storage.domain.StorageModel;
import cn.gtmap.ai.core.service.token.application.AiXtJkglModelService;
import cn.gtmap.ai.core.service.token.domian.model.JkglModel;
import cn.gtmap.ai.core.service.token.query.JkglQuery;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import cn.gtmap.ai.core.utils.http.HttpUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.gtis.common.util.UUIDGenerator;
import com.gtis.config.PropertyPlaceholderHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

@Service
public abstract class SignService {
    private static final Logger log = LoggerFactory.getLogger(SignService.class);
    public static final String SIGN_JKGJZ = "cjzm.jmqz.url";
    public static final String SIGN_DOWN_JKGJZ = "cjzm.qzwjxz.url";
    public static final String QSRW_REDISKEY = "qsrw:id:";
    @Autowired
    private ServiceFactory serviceFactory;
    @Autowired
    private ComponentConstants componentConstants;
    @Autowired
    private AiXtJkglModelService aiXtJkglModelService;
    @Autowired
    private AiXtQsrwRepository aiXtQsrwRepository;
    @Autowired
    private AiXtQsrwQsrRepository aiXtQsrwQsrRepository;
    @Autowired
    private AiXtQsrwFjxxRepository aiXtQsrwFjxxRepository;
    @Autowired
    private AiXtQsrwQsrFjxxRelRepository aiXtQsrwQsrFjxxRelRepository;
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;
    @Autowired
    private RedisUtils redisUtils;

    public String createSignTaskBO(SignFjxxDto signFjxxDto) {
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setQydm(this.componentConstants.getQydm());
        jkglQuery.setJkgjz(SIGN_JKGJZ);
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        JSONObject jrcs = jkglModel.getJrcs();
        SignJrcsDto signJrcsDto = Objects.isNull(jrcs) ? null : (SignJrcsDto)JSONObject.parseObject((String)jrcs.toJSONString(), SignJrcsDto.class);
        String lsh = UUIDGenerator.generate18();
        SignCreateBO signCreateBo = SignConvert.INSTANCE.toBo(signJrcsDto);
        signCreateBo.setLsh(lsh);
        signCreateBo.setQsly(signFjxxDto.getQsly());
        signCreateBo.setSlbh(signFjxxDto.getSlbh());
        signCreateBo.setLcmc(signFjxxDto.getLcmc());
        signCreateBo.setHddz(signFjxxDto.getHddzRequestUrl() + "/api/sign/v1/hdtz");
        Map<String, MultipartFile> fileParams = this.setFjxxList(signFjxxDto, signCreateBo);
        String resultWjsc = this.uploadFile(jkglModel.getJkdz(), fileParams, signCreateBo, null);
        SignResponseDto signResponseDto = (SignResponseDto)JSONObject.parseObject((String)resultWjsc, SignResponseDto.class);
        if (Objects.nonNull(signResponseDto) && Objects.nonNull(signResponseDto.getData())) {
            String qsrwid = signResponseDto.getData().getQsrwid();
            AiXtQsrwSaveDto aiXtQsrwSaveDto = new AiXtQsrwSaveDto();
            aiXtQsrwSaveDto.setQsrwid(qsrwid);
            aiXtQsrwSaveDto.setQsly(signFjxxDto.getQsly());
            aiXtQsrwSaveDto.setLsh(lsh);
            aiXtQsrwSaveDto.setQszt(WjQsztEnum.WQS);
            aiXtQsrwSaveDto.setSlbh(signFjxxDto.getSlbh());
            aiXtQsrwSaveDto.setYwlx(null);
            this.insertQsrw(aiXtQsrwSaveDto);
            HashMap qsrToQsdz = Maps.newHashMap();
            for (SignResponseDataQsrxxDto signResponseDataQsrxxDto : signResponseDto.getData().getQsrxxList()) {
                qsrToQsdz.put(signResponseDataQsrxxDto.getZjh(), signResponseDataQsrxxDto.getQsdz());
            }
            HashMap fjidToFjxxid = Maps.newHashMap();
            ArrayList aiXtQsrwFjxxSaveDtoList = Lists.newArrayList();
            for (SignFjxx signFjxx : signCreateBo.getFjxxList()) {
                AiXtQsrwFjxxSaveDto aiXtQsrwFjxxSaveDto = new AiXtQsrwFjxxSaveDto();
                aiXtQsrwFjxxSaveDto.setFjxxid(UUIDGenerator.generate18());
                aiXtQsrwFjxxSaveDto.setFjid(signFjxx.getFjid());
                aiXtQsrwFjxxSaveDto.setQsrwid(qsrwid);
                aiXtQsrwFjxxSaveDto.setLsh(lsh);
                aiXtQsrwFjxxSaveDto.setFjmc(signFjxx.getFjmc());
                fjidToFjxxid.put(aiXtQsrwFjxxSaveDto.getFjid(), aiXtQsrwFjxxSaveDto.getFjxxid());
                aiXtQsrwFjxxSaveDtoList.add(aiXtQsrwFjxxSaveDto);
            }
            this.insertQsrwFjxx(aiXtQsrwFjxxSaveDtoList);
            ArrayList aiXtQsrwQsrSaveDtoList = Lists.newArrayList();
            ArrayList aiXtQsrwQsrFjxxRelSaveDtoList = Lists.newArrayList();
            for (SignQsrxx signQsrxx : signCreateBo.getQsrxxList()) {
                AiXtQsrwQsrSaveDto aiXtQsrwQsrSaveDto = AiXtQsrwQsrDtoConvert.INSTANCE.qsrToSaveDto(signQsrxx);
                aiXtQsrwQsrSaveDto.setQsrid(UUIDGenerator.generate18());
                aiXtQsrwQsrSaveDto.setQsrwid(qsrwid);
                aiXtQsrwQsrSaveDto.setLsh(lsh);
                aiXtQsrwQsrSaveDto.setQsdz(null);
                aiXtQsrwQsrSaveDto.setQszt(WjQsztEnum.WQS);
                aiXtQsrwQsrSaveDto.setQsdz(MapUtils.getString((Map)qsrToQsdz, (Object)signQsrxx.getZjh()));
                for (SignQsrxxQswj signQsrxxQswj : signQsrxx.getQswjList()) {
                    AiXtQsrwQsrFjxxRelSaveDto aiXtQsrwQsrFjxxRelSaveDto = new AiXtQsrwQsrFjxxRelSaveDto();
                    aiXtQsrwQsrFjxxRelSaveDto.setRelid(UUIDGenerator.generate18());
                    aiXtQsrwQsrFjxxRelSaveDto.setQsrwid(qsrwid);
                    aiXtQsrwQsrFjxxRelSaveDto.setLsh(lsh);
                    aiXtQsrwQsrFjxxRelSaveDto.setQsrid(aiXtQsrwQsrSaveDto.getQsrid());
                    aiXtQsrwQsrFjxxRelSaveDto.setFjxxid(MapUtils.getString((Map)fjidToFjxxid, (Object)signQsrxxQswj.getFjid()));
                    aiXtQsrwQsrFjxxRelSaveDtoList.add(aiXtQsrwQsrFjxxRelSaveDto);
                }
                aiXtQsrwQsrSaveDtoList.add(aiXtQsrwQsrSaveDto);
            }
            this.insertQsrwQsr(aiXtQsrwQsrSaveDtoList);
            this.insertQsrFjxxRel(aiXtQsrwQsrFjxxRelSaveDtoList);
            this.redisUtils.addStringValue(QSRW_REDISKEY + EncryptUtil.encryptStr(qsrwid, EncryptTypeEnum.MD5Salt), JSON.toJSONString((Object)signFjxxDto));
            return qsrwid;
        }
        return null;
    }

    public abstract List<SignQsrxx> setSignQsrxx(String var1, List<StorageModel> var2);

    public abstract String getSignFjlx(String var1);

    private Map<String, MultipartFile> setFjxxList(SignFjxxDto signFjxxDto, SignCreateBO signCreateBO) {
        MultiPartModel querMultiPartModel = new MultiPartModel();
        querMultiPartModel.setAppId(signFjxxDto.getAppid());
        querMultiPartModel.setCurrentNodeId(signFjxxDto.getFjid());
        StorageService storageService = this.serviceFactory.getStorageService(signFjxxDto.getStorageServiceKey());
        List<StorageModel> storageModelList = storageService.queryFjxx(querMultiPartModel);
        List<SignQsrxx> signQsrxxList = this.setSignQsrxx(signFjxxDto.getAppid(), storageModelList);
        signCreateBO.setQsrxxList(signQsrxxList);
        ArrayList signFjxxList = Lists.newArrayList();
        Map<String, MultipartFile> fileMap = this.getMultiPartFile(signCreateBO.getSlbh(), storageModelList, storageService, signFjxxList);
        signCreateBO.setFjxxList(signFjxxList);
        return fileMap;
    }

    private Map<String, MultipartFile> getMultiPartFile(String sqid, List<StorageModel> storageModelList, StorageService storageService, List<SignFjxx> signFjxxList) {
        if (CollectionUtils.isEmpty(storageModelList)) {
            return null;
        }
        HashMap fileMap = Maps.newHashMap();
        MultiPartModel multiPartModel = new MultiPartModel();
        for (StorageModel storageModel : storageModelList) {
            Map<String, MultipartFile> temp;
            if (CollectionUtils.isEmpty(storageModel.getChildren()) && !storageModel.isSfwjj()) {
                multiPartModel.setCurrentNodeId(storageModel.getId());
                multiPartModel.setOriginalFilename(storageModel.getName());
                fileMap.put(storageModel.getName(), this.getMultipartFile(storageService.downLoadNode(multiPartModel)));
                SignFjxx signFjxx = new SignFjxx();
                signFjxx.setFjid(storageModel.getId());
                signFjxx.setFjmc(storageModel.getName());
                signFjxx.setSqid(sqid);
                signFjxx.setQssx(String.valueOf(signFjxxList.size() + 1));
                signFjxxList.add(signFjxx);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(storageModel.getChildren()) || !Objects.nonNull(temp = this.getMultiPartFile(sqid, storageModel.getChildren(), storageService, signFjxxList))) continue;
            fileMap.putAll(temp);
        }
        return fileMap;
    }

    private MultipartFile getMultipartFile(MultiPartModel multiPartModel) {
        FileItem item = new DiskFileItemFactory().createItem("file", "multipart/form-data", true, multiPartModel.getOriginalFilename());
        try (ByteArrayInputStream input = new ByteArrayInputStream(multiPartModel.getData());){
            OutputStream os = item.getOutputStream();
            IOUtils.copy((InputStream)input, (OutputStream)os);
        }
        catch (Exception e) {
            log.error("getMultipartFile", (Throwable)e);
        }
        return new CommonsMultipartFile(item);
    }

    private String uploadFile(String url, Map<String, MultipartFile> fileParams, SignCreateBO signCreateBo, Map<String, String> headerParams) {
        String result = "";
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpPost httpPost = new HttpPost(url);
            if (MapUtils.isNotEmpty(headerParams)) {
                for (Map.Entry<String, String> entry : headerParams.entrySet()) {
                    String string = entry.getValue();
                    String key = entry.getKey();
                    if (!StringUtils.isNotBlank((CharSequence)string)) continue;
                    httpPost.setHeader(key, string);
                }
            }
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setCharset(Charset.forName("utf-8"));
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            if (fileParams != null && fileParams.size() > 0) {
                for (Map.Entry<String, MultipartFile> entry : fileParams.entrySet()) {
                    MultipartFile file = entry.getValue();
                    if (file == null) continue;
                    String fileName = file.getOriginalFilename();
                    builder.addBinaryBody("file", file.getInputStream(), ContentType.MULTIPART_FORM_DATA, fileName);
                }
            }
            ContentType contentType = ContentType.create((String)"application/json", (Charset)Charset.forName("UTF-8"));
            builder.addTextBody("requestJson", JSON.toJSONString((Object)signCreateBo), contentType);
            HttpEntity httpEntity = builder.build();
            httpPost.setEntity(httpEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity responseEntity = response.getEntity();
            if (responseEntity != null) {
                result = EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
            }
        }
        catch (Exception e) {
            log.error("------uploadFile" + e.getMessage() + "," + JSON.toJSONString((Object)e.getStackTrace()) + "--------");
        }
        return result;
    }

    public Map<String, String> receiveSignHdxx(SignHdResponseDto signHdResponseDto) {
        HashMap returnMap = Maps.newHashMap();
        String code = ErrorEnum.SUCCESS.getCode();
        String msg = "\u6210\u529f";
        if (Objects.isNull(signHdResponseDto) || Objects.isNull(signHdResponseDto.getData())) {
            code = ErrorEnum.PARAM_NULL.getCode();
            msg = ErrorEnum.PARAM_NULL.getMsg();
        } else {
            AiXtQsrwSaveDto aiXtQsrwSaveDto = SignConvert.INSTANCE.toQsrw(signHdResponseDto.getData());
            this.updateQsrw(aiXtQsrwSaveDto);
            List<AiXtQsrwQsrSaveDto> dtoList = SignConvert.INSTANCE.toQsrList(signHdResponseDto.getData().getQsrxxList());
            if (CollectionUtils.isNotEmpty(dtoList)) {
                for (AiXtQsrwQsrSaveDto aiXtQsrwQsrSaveDto : dtoList) {
                    aiXtQsrwQsrSaveDto.setQsrwid(aiXtQsrwSaveDto.getQsrwid());
                }
                List<AiXtQsrwQsrModel> aiXtQsrwQsrModelList = this.updateQsrwQsr(dtoList);
                if (CollectionUtils.isNotEmpty(dtoList = dtoList.stream().filter(dto -> StringUtils.equals((CharSequence)(Objects.nonNull(dto.getQszt()) ? dto.getQszt().getDm() : null), (CharSequence)WjQsztEnum.QSWC.getDm())).collect(Collectors.toList()))) {
                    JkglQuery jkglQuery = new JkglQuery();
                    jkglQuery.setQydm(this.componentConstants.getQydm());
                    jkglQuery.setJkgjz(SIGN_DOWN_JKGJZ);
                    JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
                    SignQuery signQuery = new SignQuery();
                    signQuery.setQsrwid(signHdResponseDto.getData().getQsrwid());
                    List<AiXtQsrwQsrFjxxRelModel> relModelList = this.queryQsrFjxxRelDtoList(signQuery);
                    List<AiXtQsrwFjxxModel> fjxxModelList = this.queryQsrFjxxDtoList(signQuery);
                    HashMap relModelToQsr = Maps.newHashMap();
                    String signFjxxDtoStr = this.redisUtils.getStringValue(QSRW_REDISKEY + EncryptUtil.encryptStr(signHdResponseDto.getData().getQsrwid(), EncryptTypeEnum.MD5Salt));
                    SignFjxxDto signFjxxDto = (SignFjxxDto)JSONObject.parseObject((String)signFjxxDtoStr, SignFjxxDto.class);
                    if (CollectionUtils.isNotEmpty(relModelList)) {
                        for (AiXtQsrwQsrFjxxRelModel aiXtQsrwQsrFjxxRelModel : relModelList) {
                            List relModelListTemp = (List)MapUtils.getObject((Map)relModelToQsr, (Object)aiXtQsrwQsrFjxxRelModel.getQsrid());
                            if (Objects.isNull(relModelListTemp)) {
                                relModelListTemp = Lists.newArrayList();
                            }
                            relModelListTemp.add(aiXtQsrwQsrFjxxRelModel);
                            relModelToQsr.put(aiXtQsrwQsrFjxxRelModel.getQsrid(), relModelListTemp);
                        }
                    }
                    HashMap fjxxModelToFjxxid = Maps.newHashMap();
                    if (CollectionUtils.isNotEmpty(fjxxModelList)) {
                        for (AiXtQsrwFjxxModel aiXtQsrwFjxxModel : fjxxModelList) {
                            fjxxModelToFjxxid.put(aiXtQsrwFjxxModel.getFjxxid(), aiXtQsrwFjxxModel);
                        }
                    }
                    PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("{", "}");
                    Properties properties = new Properties();
                    properties.setProperty("lsh", signHdResponseDto.getData().getLsh());
                    HashSet fjidSets = Sets.newHashSet();
                    ArrayList taskList = Lists.newArrayList();
                    for (AiXtQsrwQsrModel aiXtQsrwQsrModel : aiXtQsrwQsrModelList) {
                        List relModelListTemp = (List)MapUtils.getObject((Map)relModelToQsr, (Object)aiXtQsrwQsrModel.getQsrid());
                        if (!CollectionUtils.isNotEmpty((Collection)relModelListTemp)) continue;
                        for (AiXtQsrwQsrFjxxRelModel aiXtQsrwQsrFjxxRelModel : relModelListTemp) {
                            AiXtQsrwFjxxModel aiXtQsrwFjxxModel = (AiXtQsrwFjxxModel)MapUtils.getObject((Map)fjxxModelToFjxxid, (Object)aiXtQsrwQsrFjxxRelModel.getFjxxid());
                            if (!Objects.nonNull(aiXtQsrwFjxxModel) || !fjidSets.add(aiXtQsrwFjxxModel.getFjid())) continue;
                            properties.setProperty("fjid", aiXtQsrwFjxxModel.getFjid());
                            String url = jkglModel.getJkdz();
                            String finalUrl = propertyPlaceholderHelper.replacePlaceholders(url, properties);
                            CompletableFuture<Boolean> task = CompletableFuture.supplyAsync(() -> {
                                try {
                                    return this.uploadFile(finalUrl, aiXtQsrwFjxxModel.getFjid(), aiXtQsrwFjxxModel.getFjmc(), signFjxxDto);
                                }
                                catch (Exception e) {
                                    log.error("SignService uploadFile thread excute exception:{}", (Throwable)e);
                                    return false;
                                }
                            }, (Executor)this.taskExecutor);
                            taskList.add(task);
                        }
                    }
                    if (StringUtils.equals((CharSequence)signHdResponseDto.getData().getQszt(), (CharSequence)WjQsztEnum.QSWC.getDm()) && CollectionUtils.isNotEmpty((Collection)taskList)) {
                        Boolean success = true;
                        for (CompletableFuture task : taskList) {
                            try {
                                success = (Boolean)task.get();
                            }
                            catch (Exception e) {
                                success = false;
                            }
                            if (success.booleanValue()) continue;
                            break;
                        }
                        if (success.booleanValue()) {
                            this.redisUtils.deleteKey(QSRW_REDISKEY + EncryptUtil.encryptStr(signHdResponseDto.getData().getQsrwid(), EncryptTypeEnum.MD5Salt));
                        } else {
                            code = ErrorEnum.SERVICE_ERROR.getCode();
                            msg = ErrorEnum.SERVICE_ERROR.getMsg();
                        }
                    }
                }
            }
        }
        returnMap.put("code", code);
        returnMap.put("msg", msg);
        return returnMap;
    }

    private boolean insertQsrw(AiXtQsrwSaveDto dto) {
        return this.aiXtQsrwRepository.insertQsrw(dto);
    }

    private boolean updateQsrw(AiXtQsrwSaveDto dto) {
        return this.aiXtQsrwRepository.updateQsrw(dto);
    }

    private boolean insertQsrwQsr(List<AiXtQsrwQsrSaveDto> dtoList) {
        return this.aiXtQsrwQsrRepository.insertQsrBacth(dtoList);
    }

    private List<AiXtQsrwQsrModel> updateQsrwQsr(List<AiXtQsrwQsrSaveDto> dtoList) {
        return this.aiXtQsrwQsrRepository.updateQsrBacth(dtoList);
    }

    private boolean insertQsrwFjxx(List<AiXtQsrwFjxxSaveDto> dtoList) {
        return this.aiXtQsrwFjxxRepository.insertQsrwFjxxBacth(dtoList);
    }

    private boolean insertQsrFjxxRel(List<AiXtQsrwQsrFjxxRelSaveDto> dtoList) {
        return this.aiXtQsrwQsrFjxxRelRepository.insertQsrFjxxRelBacth(dtoList);
    }

    public List<AiXtQsrwQsrDto> queryQsrDtoList(SignQuery signQuery) {
        return AiXtQsrwQsrDtoConvert.INSTANCE.modelToDtoList(this.aiXtQsrwQsrRepository.queryQsr(signQuery));
    }

    public List<AiXtQsrwQsrFjxxRelModel> queryQsrFjxxRelDtoList(SignQuery signQuery) {
        return this.aiXtQsrwQsrFjxxRelRepository.queryQsrFjxxRel(signQuery);
    }

    public List<AiXtQsrwFjxxModel> queryQsrFjxxDtoList(SignQuery signQuery) {
        return this.aiXtQsrwFjxxRepository.queryQsrwFjxx(signQuery);
    }

    private Boolean uploadFile(String url, String fjid, String fileName, SignFjxxDto signFjxxDto) {
        byte[] bytes = HttpUtil.dwonlaodFile(url);
        MultiPartModel multiPartModel = new MultiPartModel();
        multiPartModel.setFjid(fjid);
        multiPartModel.setRename(0);
        multiPartModel.setOriginalFilename(fileName);
        multiPartModel.setData(bytes);
        StorageModel storageModel = this.serviceFactory.getStorageService(signFjxxDto.getStorageServiceKey()).uploadFile(multiPartModel);
        return Objects.nonNull(storageModel) && StringUtils.isNotBlank((CharSequence)storageModel.getId());
    }
}

