/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.setting.application.impl;

import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.setting.application.AiXtFjpzService;
import cn.gtmap.ai.core.service.setting.domian.model.AiXtFjpz;
import cn.gtmap.ai.core.service.setting.domian.repository.AiXtFjpzRepository;
import cn.gtmap.ai.core.service.setting.query.AiXtFjpzQuery;
import cn.gtmap.ai.core.service.storage.application.FjInitService;
import cn.gtmap.ai.core.service.storage.domain.MultiPartModel;
import cn.gtmap.ai.core.service.storage.domain.StorageModel;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class AiXtFjpzServiceImpl
implements AiXtFjpzService {
    private static final Logger log = LoggerFactory.getLogger(AiXtFjpzServiceImpl.class);
    @Autowired
    private AiXtFjpzRepository aiXtFjpzRepository;
    @Autowired
    private ServiceFactory serviceFactory;
    @Autowired
    private ThreadPoolTaskExecutor taskExecutor;

    @Override
    public List<AiXtFjpz> listFjpz(AiXtFjpzQuery query) {
        return this.aiXtFjpzRepository.listFjpz(query);
    }

    @Override
    public IError initFjclByFjpz(AiXtFjpzQuery query) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{query.getSqlxdm(), query.getAppId()})) {
            return ErrorEnum.PARAM_NULL;
        }
        List<AiXtFjpz> aiXtFjpzList = this.aiXtFjpzRepository.listFjpz(query);
        if (CollectionUtils.isEmpty(aiXtFjpzList)) {
            return ErrorEnum.SUCCESS;
        }
        MultiPartModel multiPartModel = new MultiPartModel();
        multiPartModel.setAppId(query.getAppId());
        multiPartModel.setParentFolderNodeId(query.getParentNodeId());
        for (AiXtFjpz aiXtFjpz : aiXtFjpzList) {
            FjInitService fjInitService;
            multiPartModel.setTag(aiXtFjpz.getFjlx());
            StorageModel storageModel = this.serviceFactory.getStorageService(aiXtFjpz.getFjyydm()).createFolder(multiPartModel);
            if (!StringUtils.isNotBlank((CharSequence)aiXtFjpz.getSxl()) || !Objects.nonNull(fjInitService = this.serviceFactory.getFjInitService(aiXtFjpz.getSxl()))) continue;
            CompletableFuture.runAsync(() -> {
                try {
                    fjInitService.initFjxx(aiXtFjpz, query.getAppId(), storageModel.getId());
                }
                catch (Exception e) {
                    log.error(" ctc destoryView thread excute exception:{}", (Throwable)e);
                }
            }, (Executor)this.taskExecutor);
        }
        return ErrorEnum.SUCCESS;
    }
}

