/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.service.auth.application.impl;

import cn.gtmap.ai.core.base.AuthTokenDto;
import cn.gtmap.ai.core.constant.ComponentConstants;
import cn.gtmap.ai.core.constant.UserRedisContants;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.exception.ParamException;
import cn.gtmap.ai.core.exception.PzxException;
import cn.gtmap.ai.core.exception.TokenException;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.auth.application.convert.UserInfoConverter;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginResultDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginTokenDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginUserBaseDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoRoleDto;
import cn.gtmap.ai.core.service.token.application.impl.AiXtJkglModelServiceImpl;
import cn.gtmap.ai.core.service.token.domian.model.AiXtDsfxtjr;
import cn.gtmap.ai.core.service.token.domian.model.AiXtJkgl;
import cn.gtmap.ai.core.service.token.domian.model.JkglModel;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.OlcommonBaseRequestBo;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.OlcommonBaseResponseDto;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.encrypt.OlcommonEncryptBO;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.encrypt.OlcommonEncryptDto;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.login.OlcommonLoginBO;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.login.OlcommonLoginDto;
import cn.gtmap.ai.core.service.token.domian.model.olcommon.logout.OlcommonLogoutBO;
import cn.gtmap.ai.core.service.token.domian.repository.AiXtDsfxtjrRepository;
import cn.gtmap.ai.core.service.token.domian.repository.AiXtJkglRepository;
import cn.gtmap.ai.core.service.token.query.JkglQuery;
import cn.gtmap.ai.core.service.user.domain.model.olcommon.OlcommonUserInfoBO;
import cn.gtmap.ai.core.service.user.domain.model.olcommon.OlcommonUserInfoByUseridBO;
import cn.gtmap.ai.core.service.user.domain.model.olcommon.OlcommonUserInfoDto;
import cn.gtmap.ai.core.utils.desensitization.DesensitizedUtil;
import cn.gtmap.ai.core.utils.encryption.sm2.Sm2lib;
import cn.gtmap.ai.core.utils.http.HttpUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import cn.gtmap.ai.core.utils.string.StringUtil;
import cn.gtmap.estateplat.utils.CommonUtil;
import cn.gtmap.estateplat.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONValidator;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.gtis.common.util.UUIDGenerator;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="olcommonAuthServiceImpl")
public class OlcommonAuthServiceImpl
implements AuthService {
    private static final Logger log = LoggerFactory.getLogger(OlcommonAuthServiceImpl.class);
    @Autowired
    private ComponentConstants componentConstants;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private AiXtJkglModelServiceImpl aiXtJkglModelService;
    @Autowired
    private AiXtJkglRepository aiXtJkglRepository;
    @Autowired
    private AiXtDsfxtjrRepository aiXtDsfxtjrRepository;
    @Autowired
    private HttpUtil httpUtil;
    private static final String LOGIN_JKGJZ = "register.login.url";
    private static final String LOGOUT_JKGJZ = "olcommon.logout.url";
    private static final String ENCRYPT_JKGJZ = "olcommon.encrypt.url";
    private static final String USERINFO_JKGJZ = "olcommon.userinfo.url";
    private static final String USERINFO_USERID_JKGJZ = "olcommon.userinfobyuserid.url";

    @Override
    public LoginResultDto login(LoginUserBaseDto loginUserBaseDto) {
        LoginResultDto loginResultDto = new LoginResultDto();
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginUserBaseDto.getLxdh(), loginUserBaseDto.getPassword()})) {
            loginResultDto.setError(ErrorEnum.PARAM_NULL);
            return loginResultDto;
        }
        JkglQuery tokenJkglQuery = new JkglQuery();
        tokenJkglQuery.setJkgjz(LOGIN_JKGJZ);
        tokenJkglQuery.setQydm(this.componentConstants.getQydm());
        AiXtJkgl aiXtJkglToken = this.aiXtJkglModelService.replaceJkglProperties(tokenJkglQuery);
        if (Objects.nonNull(aiXtJkglToken)) {
            tokenJkglQuery.setJkgjz(null);
            tokenJkglQuery.setYydm(aiXtJkglToken.getYydm());
            tokenJkglQuery.setQydm(aiXtJkglToken.getQydm());
            AiXtDsfxtjr aiXtDsfxtjr = this.aiXtDsfxtjrRepository.getAiXtDsfxtjrByJkglQuery(tokenJkglQuery);
            if (Objects.nonNull(aiXtDsfxtjr) && JSONValidator.from((String)aiXtDsfxtjr.getJrcs()).validate() && (loginResultDto = this.getToken(aiXtJkglToken, aiXtDsfxtjr, loginUserBaseDto)).isSuccesss() && Objects.isNull(loginResultDto.getUserInfoDto())) {
                this.getUserInfo(loginResultDto.getToken(), loginResultDto);
            }
        }
        return loginResultDto;
    }

    @Override
    public IError logout() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (Objects.isNull(request)) {
            return ErrorEnum.SUCCESS;
        }
        String token = request.getParameter("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = this.redisUtils.getStringValue(UserRedisContants.getApiauthTokenBySessionPrefixRedisKey(request.getSession().getId()));
        }
        if (StringUtils.isNotBlank((CharSequence)token)) {
            this.redisUtils.deleteKey(UserRedisContants.getApiauthTokenBySessionPrefixRedisKey(request.getSession().getId()));
            String userInfo = this.redisUtils.getStringValue(UserRedisContants.getUserinfoByTokenPrefixRedisKey(token));
            if (StringUtils.isNotBlank((CharSequence)userInfo)) {
                this.redisUtils.deleteKey(UserRedisContants.getUserinfoByTokenPrefixRedisKey(token));
                LoginResultDto loginResultDto = (LoginResultDto)JSON.parseObject((String)userInfo, LoginResultDto.class);
                if (Objects.nonNull(loginResultDto) && Objects.nonNull(loginResultDto.getUserInfoDto()) && StringUtils.isNotBlank((CharSequence)loginResultDto.getUserInfoDto().getLxdh())) {
                    this.redisUtils.deleteKey(UserRedisContants.getApiauthAccesstokenByloginnamePrefixRedisKey(loginResultDto.getUserInfoDto().getLxdh(), this.componentConstants.getQydm()));
                    if (StringUtils.isNotBlank((CharSequence)loginResultDto.getClientId())) {
                        this.redisUtils.deleteKey(UserRedisContants.getRestauthOrginalTokenByClientTokenPrefixRedisKey(loginResultDto.getToken()));
                        this.redisUtils.deleteKey(UserRedisContants.getRestauthClientByTokenPrefixRedisKey(loginResultDto.getToken()));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)token)) {
                    JkglQuery jkglQuery = new JkglQuery();
                    jkglQuery.setJkgjz(LOGOUT_JKGJZ);
                    jkglQuery.setQydm(this.componentConstants.getQydm());
                    JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
                    if (StringUtils.isNotBlank((CharSequence)jkglModel.getJkdz())) {
                        OlcommonBaseRequestBo<Class<OlcommonLogoutBO>> olcommonBaseUserInfoRequestBo = new OlcommonBaseRequestBo<Class<OlcommonLogoutBO>>(OlcommonLogoutBO.class);
                        olcommonBaseUserInfoRequestBo.getHead().setAccessToken(token);
                        String result = HttpUtil.post(jkglModel.getJkdz(), JSON.toJSONString(olcommonBaseUserInfoRequestBo), null, null);
                        log.info("olcommon.encrypt.key {}httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), jkglModel.getJkdz(), result});
                        return ErrorEnum.SUCCESS;
                    }
                    return ErrorEnum.PZX_NOT_EXISTS;
                }
            }
            return ErrorEnum.SUCCESS;
        }
        return ErrorEnum.UN_AUTHORIZED;
    }

    public LoginResultDto getToken(AiXtJkgl aiXtJkglToken, AiXtDsfxtjr aiXtDsfxtjr, LoginUserBaseDto loginUserBaseDto) {
        if (Objects.isNull(aiXtJkglToken) || StringUtils.isBlank((CharSequence)aiXtJkglToken.getJkdz())) {
            throw new BizException(ErrorEnum.PARAM_NULL.getCode(), "\u63a5\u53e3\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String accessToken = "";
        String lxdh = null;
        String password = null;
        String encodeValue = null;
        if (Objects.nonNull(loginUserBaseDto) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginUserBaseDto.getLxdh(), loginUserBaseDto.getPassword()})) {
            lxdh = loginUserBaseDto.getLxdh();
            password = loginUserBaseDto.getPassword();
        } else if (Objects.nonNull(aiXtDsfxtjr) && StringUtils.isNotBlank((CharSequence)aiXtDsfxtjr.getJrcs())) {
            JSONObject jrqtcs = JSONObject.parseObject((String)aiXtDsfxtjr.getJrcs());
            lxdh = CommonUtil.formatEmptyValue((Object)jrqtcs.get((Object)"lxdh"));
            encodeValue = password = Sm2lib.decode(CommonUtil.formatEmptyValue((Object)jrqtcs.get((Object)"password")));
        }
        LoginResultDto loginResultDto = new LoginResultDto();
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{lxdh, password})) {
            loginResultDto.setError(ErrorEnum.PARAM_NULL);
            return loginResultDto;
        }
        String redisKey = UserRedisContants.getApiauthAccesstokenByloginnamePrefixRedisKey(lxdh, aiXtJkglToken.getQydm());
        String token = this.redisUtils.getStringValue(redisKey);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            log.info("{},\u83b7\u53d6\u65f6\u95f4:{},\u672a\u8fc7\u671f", (Object)redisKey, (Object)DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT));
            this.getUserInfo(token, loginResultDto);
            if (Objects.nonNull(loginResultDto) && loginResultDto.isSuccesss()) {
                accessToken = token;
            }
        }
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            if (StringUtils.isBlank((CharSequence)encodeValue)) {
                JkglQuery jkglQuery = new JkglQuery();
                jkglQuery.setJkgjz(ENCRYPT_JKGJZ);
                jkglQuery.setQydm(this.componentConstants.getQydm());
                JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
                String queryUrl = jkglModel.getJkdz();
                if (StringUtils.isNotBlank((CharSequence)queryUrl)) {
                    OlcommonBaseResponseDto olcommonBaseEncryptDto;
                    OlcommonBaseRequestBo<Class<OlcommonEncryptBO>> olcommonBaseEncryptRequestBo = new OlcommonBaseRequestBo<Class<OlcommonEncryptBO>>(OlcommonEncryptBO.class);
                    OlcommonEncryptBO olcommonEncryptBO = (OlcommonEncryptBO)((Object)olcommonBaseEncryptRequestBo.getData());
                    olcommonEncryptBO.setEncodeKey(password);
                    String result = HttpUtil.post(queryUrl, JSON.toJSONString(olcommonBaseEncryptRequestBo), null, null);
                    log.info("olcommon.encrypt.key {}httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), queryUrl, result});
                    if (JSONValidator.from((String)result).validate() && Objects.nonNull(olcommonBaseEncryptDto = (OlcommonBaseResponseDto)JSON.parseObject((String)result, (TypeReference)new TypeReference<OlcommonBaseResponseDto<OlcommonEncryptDto>>(){}, (Feature[])new Feature[0])) && olcommonBaseEncryptDto.isSuccess()) {
                        String string = encodeValue = Objects.isNull(olcommonBaseEncryptDto.getData()) ? null : ((OlcommonEncryptDto)olcommonBaseEncryptDto.getData()).getEncodeValue();
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)encodeValue)) {
                String olcommonyhqxTokenKeyUrl = aiXtJkglToken.getJkdz();
                OlcommonBaseRequestBo<Class<OlcommonLoginBO>> olcommonBaseLoginRequestBo = new OlcommonBaseRequestBo<Class<OlcommonLoginBO>>(OlcommonLoginBO.class);
                OlcommonLoginBO olcommonLoginBO = (OlcommonLoginBO)((Object)olcommonBaseLoginRequestBo.getData());
                olcommonLoginBO.setLxDh(lxdh);
                olcommonLoginBO.setUserPwd(encodeValue);
                String result = HttpUtil.post(olcommonyhqxTokenKeyUrl, JSON.toJSONString(olcommonBaseLoginRequestBo), null, null);
                log.info("olcommon.token.key {}httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), olcommonyhqxTokenKeyUrl, result});
                if (JSONValidator.from((String)result).validate()) {
                    final OlcommonBaseResponseDto olcommonBaseLoginDto = (OlcommonBaseResponseDto)JSON.parseObject((String)result, (TypeReference)new TypeReference<OlcommonBaseResponseDto<OlcommonLoginDto>>(){}, (Feature[])new Feature[0]);
                    if (Objects.nonNull(olcommonBaseLoginDto) && olcommonBaseLoginDto.isSuccess()) {
                        String string = accessToken = Objects.isNull(olcommonBaseLoginDto.getData()) ? null : ((OlcommonLoginDto)olcommonBaseLoginDto.getData()).getAccessToken();
                        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                            loginResultDto.setExpiresIn(5400L);
                            loginResultDto.setToken(accessToken);
                            loginResultDto.setError(ErrorEnum.SUCCESS);
                            this.redisUtils.addStringValue(redisKey, accessToken, loginResultDto.getExpiresIn());
                        }
                    } else {
                        loginResultDto.setError(new IError(){

                            @Override
                            public String getCode() {
                                return olcommonBaseLoginDto.getHead().getStatusCode();
                            }

                            @Override
                            public String getMsg() {
                                return olcommonBaseLoginDto.getHead().getMsg();
                            }

                            @Override
                            public boolean isSuccesss() {
                                return false;
                            }
                        });
                    }
                }
            }
        }
        return loginResultDto;
    }

    public void getUserInfo(String token, LoginResultDto loginResultDto) {
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setJkgjz(USERINFO_JKGJZ);
        jkglQuery.setQydm(this.componentConstants.getQydm());
        AiXtJkgl aiXtJkglUser = this.aiXtJkglModelService.replaceJkglProperties(jkglQuery);
        if (Objects.nonNull(aiXtJkglUser) && StringUtils.isNotBlank((CharSequence)aiXtJkglUser.getJkdz())) {
            if (StringUtils.isNotBlank((CharSequence)token)) {
                token = token.replace(" ", "+");
            }
            OlcommonBaseRequestBo<Class<OlcommonUserInfoBO>> olcommonBaseUserInfoRequestBo = new OlcommonBaseRequestBo<Class<OlcommonUserInfoBO>>(OlcommonUserInfoBO.class);
            OlcommonUserInfoBO olcommonUserInfoBO = (OlcommonUserInfoBO)((Object)olcommonBaseUserInfoRequestBo.getData());
            olcommonUserInfoBO.setAccessToken(token);
            String queryUrl = aiXtJkglUser.getJkdz();
            String result = HttpUtil.post(queryUrl, JSON.toJSONString(olcommonBaseUserInfoRequestBo), null, null);
            log.info("olcommon.userinfo.key {} httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), queryUrl, result});
            if (JSONValidator.from((String)result).validate()) {
                OlcommonBaseResponseDto olcommonBaseUserInfoDto = (OlcommonBaseResponseDto)JSON.parseObject((String)result, (TypeReference)new TypeReference<OlcommonBaseResponseDto<OlcommonUserInfoDto>>(){}, (Feature[])new Feature[0]);
                if (!olcommonBaseUserInfoDto.isSuccess()) {
                    if (Objects.nonNull(olcommonBaseUserInfoDto.getHead())) {
                        throw new TokenException(olcommonBaseUserInfoDto.getHead().getCode(), olcommonBaseUserInfoDto.getHead().getMsg());
                    }
                    throw new BizException(ErrorEnum.SERVICE_ERROR);
                }
                OlcommonUserInfoDto olcommonUserInfoDto = (OlcommonUserInfoDto)olcommonBaseUserInfoDto.getData();
                if (Objects.isNull(olcommonUserInfoDto)) {
                    log.info("getUserInfo() - olcommonUserInfoDto \u503c\u4e3a\u7a7a");
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)loginResultDto.getClientId())) {
                    token = StringUtil.crossCombine(token, loginResultDto.getClientId());
                }
                UserInfoDto userInfoDto = UserInfoConverter.INSTANCE.olcommonUserToUserInfoDto(olcommonUserInfoDto);
                userInfoDto.setDsfyhInfo(JSON.toJSONString((Object)olcommonUserInfoDto));
                DesensitizedUtil.desensitizeObj(userInfoDto);
                ArrayList roleDtoList = Lists.newArrayList();
                userInfoDto.setRoleList(roleDtoList);
                UserInfoRoleDto userInfoRoleDto = new UserInfoRoleDto();
                userInfoRoleDto.setRoleId(String.valueOf(olcommonUserInfoDto.getRole()));
                userInfoRoleDto.setRoleName(olcommonUserInfoDto.getRoleName());
                loginResultDto.setUserInfoDto(userInfoDto);
                loginResultDto.setToken(token);
                loginResultDto.setError(ErrorEnum.SUCCESS);
                loginResultDto.setExpiresIn(5400L);
                String redisKey = UserRedisContants.getUserinfoByTokenPrefixRedisKey(token);
                this.redisUtils.addStringValue(redisKey, JSON.toJSONString((Object)loginResultDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}), loginResultDto.getExpiresIn());
            } else {
                loginResultDto.setError(ErrorEnum.REOMTE_SERVICE_ERROR);
            }
        }
    }

    @Override
    public UserInfoDto getUserInfoByToken(String token) {
        if (StringUtils.isNotBlank((CharSequence)token)) {
            token = token.replace(" ", "+");
        }
        LoginResultDto loginResultDto = new LoginResultDto();
        this.getUserInfo(token, loginResultDto);
        if (loginResultDto.isSuccesss()) {
            return loginResultDto.getUserInfoDto();
        }
        String orinalToken = this.redisUtils.getStringValue(UserRedisContants.getRestauthOrginalTokenByClientTokenPrefixRedisKey(token));
        this.getUserInfo(orinalToken, loginResultDto);
        if (loginResultDto.isSuccesss()) {
            return loginResultDto.getUserInfoDto();
        }
        return null;
    }

    @Override
    public IError checkLogin(LoginUserBaseDto loginUserBaseDto) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (Objects.isNull(request)) {
            return ErrorEnum.SERVICE_ERROR;
        }
        String redisKey = UserRedisContants.getApiauthTokenBySessionPrefixRedisKey(request.getSession().getId());
        String token = this.redisUtils.getStringValue(redisKey);
        return StringUtils.isNotBlank((CharSequence)token) ? ErrorEnum.SUCCESS : ErrorEnum.SERVICE_ERROR;
    }

    @Override
    public AuthTokenDto generateToken(LoginUserBaseDto loginUserBaseDto) {
        log.info("**********LoginUserBaseDto:{}***********", (Object)JSON.toJSONString((Object)loginUserBaseDto));
        AuthTokenDto authTokenDto = new AuthTokenDto();
        LoginResultDto loginResultDto = new LoginResultDto();
        JkglQuery tokenJkglQuery = new JkglQuery();
        tokenJkglQuery.setJkgjz(LOGIN_JKGJZ);
        tokenJkglQuery.setQydm(this.componentConstants.getQydm());
        AiXtJkgl aiXtJkglToken = this.aiXtJkglModelService.replaceJkglProperties(tokenJkglQuery);
        if (Objects.isNull(aiXtJkglToken)) {
            return authTokenDto;
        }
        String accessToken = "";
        if (StringUtils.isNotBlank((CharSequence)aiXtJkglToken.getJkdz()) && Objects.nonNull(loginUserBaseDto)) {
            String lxdh = null;
            String password = null;
            String encodeValue = null;
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginUserBaseDto.getYhm(), loginUserBaseDto.getMm()})) {
                lxdh = loginUserBaseDto.getYhm();
                password = loginUserBaseDto.getMm();
            }
            if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{lxdh, password})) {
                throw new TokenException(ErrorEnum.PARAM_NULL);
            }
            boolean differentClient = StringUtils.isNotBlank((CharSequence)loginUserBaseDto.getClientId());
            loginResultDto.setClientId(loginUserBaseDto.getClientId());
            String redisKey = UserRedisContants.getRestauthRestTokenByLoginnamePrefixRedisKey(loginUserBaseDto.getClientId(), lxdh, aiXtJkglToken.getQydm());
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                if (StringUtils.isBlank(encodeValue)) {
                    JkglQuery jkglQuery = new JkglQuery();
                    jkglQuery.setJkgjz(ENCRYPT_JKGJZ);
                    jkglQuery.setQydm(aiXtJkglToken.getQydm());
                    JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
                    if (StringUtils.isNotBlank((CharSequence)jkglModel.getJkdz())) {
                        OlcommonBaseResponseDto olcommonBaseEncryptDto;
                        String queryUrl = jkglModel.getJkdz();
                        OlcommonBaseRequestBo<Class<OlcommonEncryptBO>> olcommonBaseEncryptRequestBo = new OlcommonBaseRequestBo<Class<OlcommonEncryptBO>>(OlcommonEncryptBO.class);
                        OlcommonEncryptBO olcommonEncryptBO = (OlcommonEncryptBO)((Object)olcommonBaseEncryptRequestBo.getData());
                        olcommonEncryptBO.setEncodeKey(password);
                        String result = HttpUtil.post(queryUrl, JSON.toJSONString(olcommonBaseEncryptRequestBo), null, null);
                        log.info("olcommon.encrypt.key {}httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), queryUrl, result});
                        if (JSONValidator.from((String)result).validate() && Objects.nonNull(olcommonBaseEncryptDto = (OlcommonBaseResponseDto)JSON.parseObject((String)result, (TypeReference)new TypeReference<OlcommonBaseResponseDto<OlcommonEncryptDto>>(){}, (Feature[])new Feature[0])) && olcommonBaseEncryptDto.isSuccess()) {
                            String string = encodeValue = Objects.isNull(olcommonBaseEncryptDto.getData()) ? null : ((OlcommonEncryptDto)olcommonBaseEncryptDto.getData()).getEncodeValue();
                        }
                    }
                }
                if (StringUtils.isNotBlank(encodeValue)) {
                    OlcommonBaseResponseDto olcommonBaseLoginDto;
                    String olcommonyhqxTokenKeyUrl = aiXtJkglToken.getJkdz();
                    OlcommonBaseRequestBo<Class<OlcommonLoginBO>> olcommonBaseLoginRequestBo = new OlcommonBaseRequestBo<Class<OlcommonLoginBO>>(OlcommonLoginBO.class);
                    OlcommonLoginBO olcommonLoginBO = (OlcommonLoginBO)((Object)olcommonBaseLoginRequestBo.getData());
                    olcommonLoginBO.setLxDh(lxdh);
                    olcommonLoginBO.setUserPwd(encodeValue);
                    String result = HttpUtil.post(olcommonyhqxTokenKeyUrl, JSON.toJSONString(olcommonBaseLoginRequestBo), null, null);
                    log.info("olcommon.token.key {}httpClientPost URL:{} result:{}", new Object[]{DateUtils.formatTime((Date)new Date(), (FastDateFormat)DateUtils.DATETIME_FORMAT), olcommonyhqxTokenKeyUrl, result});
                    if (JSONValidator.from((String)result).validate() && Objects.nonNull(olcommonBaseLoginDto = (OlcommonBaseResponseDto)JSON.parseObject((String)result, (TypeReference)new TypeReference<OlcommonBaseResponseDto<OlcommonLoginDto>>(){}, (Feature[])new Feature[0])) && olcommonBaseLoginDto.isSuccess()) {
                        String orginaltoken = accessToken = Objects.isNull(olcommonBaseLoginDto.getData()) ? null : ((OlcommonLoginDto)olcommonBaseLoginDto.getData()).getAccessToken();
                        if (StringUtils.isNotBlank((CharSequence)accessToken)) {
                            loginResultDto.setExpiresIn(5400L);
                            loginResultDto.setToken(accessToken);
                            loginResultDto.setError(ErrorEnum.SUCCESS);
                            this.getUserInfo(accessToken, loginResultDto);
                            if (differentClient) {
                                accessToken = StringUtil.crossCombine(accessToken, loginUserBaseDto.getClientId());
                            }
                            authTokenDto.setToken(accessToken);
                            authTokenDto.setExpireIn(((OlcommonLoginDto)olcommonBaseLoginDto.getData()).getExpiresIn());
                            this.redisUtils.addStringValue(redisKey, accessToken, loginResultDto.getExpiresIn());
                            this.redisUtils.addStringValue(UserRedisContants.getLoginNameByTokenPrefixRedisKey(accessToken), lxdh, loginResultDto.getExpiresIn());
                            if (differentClient) {
                                this.redisUtils.addStringValue(UserRedisContants.getRestauthOrginalTokenByClientTokenPrefixRedisKey(accessToken), orginaltoken, loginResultDto.getExpiresIn());
                                this.redisUtils.addStringValue(UserRedisContants.getRestauthClientByTokenPrefixRedisKey(accessToken), loginUserBaseDto.getClientId(), loginResultDto.getExpiresIn());
                            }
                        }
                    }
                }
            }
        }
        return authTokenDto;
    }

    @Override
    public IError checkToken(String token) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (Objects.isNull(request)) {
            return ErrorEnum.SERVICE_ERROR;
        }
        String redisKey = UserRedisContants.getLoginNameByTokenPrefixRedisKey(token);
        return StringUtils.isNotBlank((CharSequence)this.redisUtils.getStringValue(redisKey)) ? ErrorEnum.SUCCESS : ErrorEnum.SERVICE_ERROR;
    }

    @Override
    public UserInfoDto getUserInfoByUserId(String userId) {
        LoginResultDto loginResultDto;
        if (StringUtils.isBlank((CharSequence)userId)) {
            throw new ParamException(ErrorEnum.PARAM_NULL);
        }
        String userInfo = this.redisUtils.getStringValue(UserRedisContants.getRestauthUserinfoByClientidPrefixRedisKey(userId));
        if (StringUtils.isNotBlank((CharSequence)userInfo) && Objects.nonNull(loginResultDto = (LoginResultDto)JSON.parseObject((String)userInfo, LoginResultDto.class)) && loginResultDto.isSuccesss()) {
            return loginResultDto.getUserInfoDto();
        }
        JkglQuery jkglQuery = new JkglQuery();
        jkglQuery.setJkgjz(USERINFO_USERID_JKGJZ);
        jkglQuery.setQydm(this.componentConstants.getQydm());
        JkglModel jkglModel = this.aiXtJkglModelService.getJkglModel(jkglQuery);
        if (StringUtils.isNotBlank((CharSequence)jkglModel.getJkdz())) {
            OlcommonBaseRequestBo<Class<OlcommonUserInfoByUseridBO>> olcommonBaseLoginRequestBo = new OlcommonBaseRequestBo<Class<OlcommonUserInfoByUseridBO>>(OlcommonUserInfoByUseridBO.class);
            OlcommonUserInfoByUseridBO olcommonUserInfoByUseridBO = (OlcommonUserInfoByUseridBO)((Object)olcommonBaseLoginRequestBo.getData());
            olcommonUserInfoByUseridBO.setUserGuid(userId);
            ParameterizedTypeReference<OlcommonBaseResponseDto<OlcommonUserInfoDto>> typeRef = new ParameterizedTypeReference<OlcommonBaseResponseDto<OlcommonUserInfoDto>>(){};
            olcommonBaseLoginRequestBo.getHead().setAccessToken(jkglModel.getToken());
            OlcommonBaseResponseDto<OlcommonUserInfoDto> olcommonBaseUserInfoDto = this.httpUtil.getPostData(JSON.toJSONString(olcommonBaseLoginRequestBo), jkglModel.getJkdz(), typeRef, jkglModel.getJkgjz(), UUIDGenerator.generate18());
            if (Objects.isNull(olcommonBaseUserInfoDto) || !olcommonBaseUserInfoDto.isSuccess()) {
                throw new BizException(ErrorEnum.REOMTE_SERVICE_ERROR);
            }
            OlcommonUserInfoDto olcommonUserInfoDto = olcommonBaseUserInfoDto.getData();
            if (Objects.isNull(olcommonUserInfoDto)) {
                log.info("getUserInfoByUserId() - olcommonUserInfoDto \u503c\u4e3a\u7a7a");
                throw new BizException(ErrorEnum.NOT_FOUND);
            }
            UserInfoDto userInfoDto = UserInfoConverter.INSTANCE.olcommonUserToUserInfoDto(olcommonUserInfoDto);
            userInfoDto.setDsfyhInfo(JSON.toJSONString((Object)olcommonUserInfoDto));
            DesensitizedUtil.desensitizeObj(userInfoDto);
            ArrayList roleDtoList = Lists.newArrayList();
            userInfoDto.setRoleList(roleDtoList);
            UserInfoRoleDto userInfoRoleDto = new UserInfoRoleDto();
            userInfoRoleDto.setRoleId(String.valueOf(olcommonUserInfoDto.getRole()));
            userInfoRoleDto.setRoleName(olcommonUserInfoDto.getRoleName());
            LoginResultDto loginResultDto2 = new LoginResultDto();
            loginResultDto2.setClientId(userId);
            loginResultDto2.setExpiresIn(5400L);
            loginResultDto2.setError(ErrorEnum.SUCCESS);
            loginResultDto2.setUserInfoDto(userInfoDto);
            this.redisUtils.addStringValue(UserRedisContants.getRestauthUserinfoByClientidPrefixRedisKey(userId), JSON.toJSONString((Object)loginResultDto2, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString}), loginResultDto2.getExpiresIn());
            return userInfoDto;
        }
        throw new PzxException("\u901a\u8fc7userId\u83b7\u53d6\u7528\u6237\u4fe1\u606f: " + jkglQuery.getJkgjz() + "\u914d\u7f6e\u6709\u8bef,\u8bf7\u68c0\u67e5!");
    }

    @Override
    public LoginResultDto login(LoginTokenDto loginTokenDto) {
        return null;
    }
}

