/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.mybaitsplus.query;

import cn.gtmap.ai.core.mybaitsplus.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.SharedString;
import com.baomidou.mybatisplus.core.conditions.query.Query;
import com.baomidou.mybatisplus.core.conditions.segments.MergeSegments;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;

public class SafeQueryWrapper<T>
extends AbstractWrapper<T, String, SafeQueryWrapper<T>>
implements Query<SafeQueryWrapper<T>, T, String> {
    private final SharedString sqlSelect = new SharedString();
    private static final Pattern REPLACE_BLANK = Pattern.compile("\"|\\<|\\>|&|\\*|\\+|=|#|-|;");
    private static final Pattern SQL_SYNTAX_PATTERN = Pattern.compile("(insert|delete|update|select|create|drop|truncate|grant|alter|deny|revoke|call|execute|exec|declare|show|rename|set)\\s+.*(into|from|set|where|table|database|view|index|on|cursor|procedure|trigger|for|password|union|and|or)|(select\\s*\\*\\s*from\\s+)", 2);
    private static final Pattern SQL_COMMENT_PATTERN = Pattern.compile("'.*(or|union|--|#|/*|;)", 2);

    public SafeQueryWrapper() {
        this(null);
    }

    public SafeQueryWrapper(T entity) {
        super.setEntity(entity);
        super.initNeed();
    }

    public SafeQueryWrapper(T entity, String ... columns) {
        super.setEntity(entity);
        super.initNeed();
        this.select(columns);
    }

    private SafeQueryWrapper(T entity, Class<T> entityClass, AtomicInteger paramNameSeq, Map<String, Object> paramNameValuePairs, MergeSegments mergeSegments, SharedString paramAlias, SharedString lastSql, SharedString sqlComment, SharedString sqlFirst) {
        super.setEntity(entity);
        super.setEntityClass(entityClass);
        this.paramNameSeq = paramNameSeq;
        this.paramNameValuePairs = paramNameValuePairs;
        this.expression = mergeSegments;
        this.paramAlias = paramAlias;
        this.lastSql = lastSql;
        this.sqlComment = sqlComment;
        this.sqlFirst = sqlFirst;
    }

    @SafeVarargs
    public final SafeQueryWrapper<T> select(String ... columns) {
        return this.select(Arrays.asList(columns));
    }

    public SafeQueryWrapper<T> select(List<String> columns) {
        if (CollectionUtils.isNotEmpty(columns)) {
            this.sqlSelect.setStringValue(String.join((CharSequence)",", columns));
        }
        return (SafeQueryWrapper)this.typedThis;
    }

    public SafeQueryWrapper<T> select(Class<T> entityClass, Predicate<TableFieldInfo> predicate) {
        super.setEntityClass(entityClass);
        this.sqlSelect.setStringValue(TableInfoHelper.getTableInfo((Class)this.getEntityClass()).chooseSelect(predicate));
        return (SafeQueryWrapper)this.typedThis;
    }

    public String getSqlSelect() {
        return this.sqlSelect.getStringValue();
    }

    public LambdaQueryWrapper<T> lambda() {
        LambdaQueryWrapper<Object> tLambdaQueryWrapper = new LambdaQueryWrapper<Object>(this.getEntity(), this.getEntityClass(), this.sqlSelect, this.paramNameSeq, this.paramNameValuePairs, this.expression, this.paramAlias, this.lastSql, this.sqlComment, this.sqlFirst);
        return tLambdaQueryWrapper;
    }

    protected SafeQueryWrapper<T> instance() {
        return new SafeQueryWrapper<Object>(this.getEntity(), this.getEntityClass(), this.paramNameSeq, this.paramNameValuePairs, new MergeSegments(), this.paramAlias, SharedString.emptyString(), SharedString.emptyString(), SharedString.emptyString());
    }

    public void clear() {
        super.clear();
        this.sqlSelect.toNull();
    }

    protected String columnSqlInjectFilter(String column) {
        if (StringUtils.isNotBlank((CharSequence)column) && (SQL_COMMENT_PATTERN.matcher(column).find() || SQL_SYNTAX_PATTERN.matcher(column).find())) {
            Matcher matcher = REPLACE_BLANK.matcher(column);
            column = matcher.replaceAll("");
        }
        return column;
    }
}

