/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.interfaces.controller.sign;

import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.sign.dto.sign.SignFjxxDto;
import cn.gtmap.ai.core.service.sign.dto.signhd.SignHdResponseDto;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import com.alibaba.fastjson.JSONObject;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/api/sign/v1"})
public class SignController {
    private static final Logger log = LoggerFactory.getLogger(SignController.class);
    @Autowired
    private ServiceFactory serviceFactory;
    @Autowired
    private RedisUtils redisUtils;

    @PostMapping(value={"/hdtz"})
    @ResponseBody
    public Map hdtz(@RequestBody MultipartFile[] file, @RequestParam(value="requestJson") @ApiParam(value="\u8bf7\u6c42\u4f53json") String requestJson) {
        SignHdResponseDto signHdResponseDto = (SignHdResponseDto)JSONObject.parseObject((String)requestJson, SignHdResponseDto.class);
        String signFjxxDtoStr = this.redisUtils.getStringValue("qsrw:id:" + EncryptUtil.encryptStr(signHdResponseDto.getData().getQsrwid(), EncryptTypeEnum.MD5Salt));
        SignFjxxDto signFjxxDto = (SignFjxxDto)JSONObject.parseObject((String)signFjxxDtoStr, SignFjxxDto.class);
        return this.serviceFactory.getSignService(signFjxxDto.getSignServiceKey()).receiveSignHdxx(signHdResponseDto);
    }
}

