/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.interfaces.controller.login;

import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.constant.UserRedisContants;
import cn.gtmap.ai.core.exception.IError;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/logout/v1"})
public class LogoutController {
    private static final Logger log = LoggerFactory.getLogger(LogoutController.class);
    @Autowired
    private ServiceFactory serviceFactory;
    @Autowired
    private RedisUtils redisUtils;

    @GetMapping(value={"/simplelogout"})
    @ResponseBody
    public ReturnResult simplelogout(HttpServletRequest request) {
        AuthService authService = this.serviceFactory.getAuthService();
        IError iError = authService.logout();
        if (Objects.nonNull(iError) && iError.isSuccesss()) {
            this.redisUtils.deleteKey(UserRedisContants.getApiauthTokenBySessionPrefixRedisKey(request.getSession().getId()));
            request.getSession().invalidate();
        }
        return ReturnResult.error(iError);
    }
}

