/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.interfaces.controller.login;

import cn.gtmap.ai.core.annotation.auth.AuthCheck;
import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.constant.ComponentConstants;
import cn.gtmap.ai.core.constant.UserRedisContants;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.enums.LoginSystemEnum;
import cn.gtmap.ai.core.enums.TokenErrorEnum;
import cn.gtmap.ai.core.enums.ZdEnum;
import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.auth.application.AppAuthService;
import cn.gtmap.ai.core.service.auth.application.AuthService;
import cn.gtmap.ai.core.service.auth.domain.model.login.AppLoginBaseDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginResultDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginTokenDto;
import cn.gtmap.ai.core.service.auth.domain.model.login.LoginUserBaseDto;
import cn.gtmap.ai.core.service.auth.domain.model.user.UserInfoDto;
import cn.gtmap.ai.core.service.user.application.UserService;
import cn.gtmap.ai.core.utils.encryption.sm2.Sm2lib;
import cn.gtmap.ai.core.utils.kaptcha.VerifyUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/login/v1"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private ComponentConstants componentConstants;
    @Autowired
    private ServiceFactory serviceFactory;
    @Autowired
    private RedisUtils redisUtils;

    @PostMapping(value={"/simpleLogin"})
    @ResponseBody
    public ReturnResult simpleLogin(@RequestBody LoginUserBaseDto loginUserBaseDto, HttpServletRequest request, HttpServletResponse response) {
        boolean yzmVerFified;
        if (StringUtils.isNotBlank((CharSequence)loginUserBaseDto.getPassword())) {
            loginUserBaseDto.setPassword(Sm2lib.pzxDecode(loginUserBaseDto.getPassword()));
        }
        if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginUserBaseDto.getPassword(), loginUserBaseDto.getLxdh()}) && !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{loginUserBaseDto.getYhm(), loginUserBaseDto.getMm()})) {
            return ReturnResult.error(ErrorEnum.PARAM_NULL);
        }
        boolean bl = yzmVerFified = this.componentConstants.getLetterYzmUse() == false;
        if (this.componentConstants.getLetterYzmUse().booleanValue()) {
            yzmVerFified = VerifyUtil.checkVerifyCode(request, loginUserBaseDto);
        }
        if (!yzmVerFified) {
            return ReturnResult.error(TokenErrorEnum.YZM_FAILED);
        }
        String redisKey = UserRedisContants.getApiauthTokenBySessionPrefixRedisKey(request.getSession().getId());
        LoginResultDto loginResultDto = null;
        UserService userService = this.serviceFactory.getUserService();
        UserInfoDto userInfoDto = userService.getCurrentUser();
        if (Objects.isNull(userInfoDto)) {
            AuthService authService = this.serviceFactory.getAuthService();
            loginResultDto = authService.login(loginUserBaseDto);
            if (Objects.nonNull(loginResultDto) && loginResultDto.isSuccesss()) {
                this.redisUtils.addStringValue(redisKey, loginResultDto.getToken(), loginResultDto.getExpiresIn());
            }
        } else {
            String token = this.redisUtils.getStringValue(redisKey);
            loginResultDto = new LoginResultDto();
            loginResultDto.setUserInfoDto(userInfoDto);
            loginResultDto.setError(ErrorEnum.SUCCESS);
            loginResultDto.setToken(token);
        }
        if (Objects.nonNull(loginResultDto) && loginResultDto.isSuccesss()) {
            loginResultDto.setError(null);
            loginResultDto.setExpiresIn(0L);
            return ReturnResult.success(loginResultDto);
        }
        if (Objects.nonNull(loginResultDto) && Objects.nonNull(loginResultDto.getError())) {
            return ReturnResult.error(loginResultDto.getError());
        }
        return ReturnResult.error();
    }

    @PostMapping(value={"/token"})
    @ResponseBody
    public ReturnResult token(@RequestBody LoginTokenDto loginTokenDto, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)loginTokenDto.getToken())) {
            loginTokenDto.setToken(Sm2lib.pzxDecode(loginTokenDto.getToken()));
        }
        if (Objects.isNull(loginTokenDto.getYydm())) {
            return ReturnResult.error(ErrorEnum.PARAM_DATANOTFOUND);
        }
        String redisKey = UserRedisContants.getApiauthTokenBySessionPrefixRedisKey(request.getSession().getId());
        LoginResultDto loginResultDto = null;
        UserService userService = this.serviceFactory.getUserService();
        UserInfoDto userInfoDto = userService.getCurrentUser();
        if (Objects.isNull(userInfoDto)) {
            AuthService authService = this.serviceFactory.getSystemAuthService(loginTokenDto.getYydm());
            loginResultDto = authService.login(loginTokenDto);
            if (Objects.nonNull(loginResultDto) && loginResultDto.isSuccesss()) {
                this.redisUtils.addStringValue(redisKey, loginResultDto.getToken(), loginResultDto.getExpiresIn());
                this.redisUtils.addStringValue(UserRedisContants.getApiauthYydmBySessionPrefixRedisKey(request.getSession().getId()), loginTokenDto.getYydm().getDm(), loginResultDto.getExpiresIn());
            }
        } else {
            String token = this.redisUtils.getStringValue(redisKey);
            loginResultDto = new LoginResultDto();
            loginResultDto.setUserInfoDto(userInfoDto);
            loginResultDto.setError(ErrorEnum.SUCCESS);
            loginResultDto.setToken(token);
        }
        if (Objects.nonNull(loginResultDto) && loginResultDto.isSuccesss()) {
            loginResultDto.setError(null);
            loginResultDto.setExpiresIn(0L);
            return ReturnResult.success(loginResultDto);
        }
        if (Objects.nonNull(loginResultDto) && Objects.nonNull(loginResultDto.getError())) {
            return ReturnResult.error(loginResultDto.getError());
        }
        return ReturnResult.error();
    }

    @PostMapping(value={"/applogin"})
    @ResponseBody
    public ReturnResult applogin(@RequestBody AppLoginBaseDto appLoginBaseDto, HttpServletRequest request, HttpServletResponse response) {
        String redisKey = UserRedisContants.getApiauthTokenBySessionPrefixRedisKey(request.getSession().getId());
        LoginResultDto loginResultDto = null;
        UserService userService = this.serviceFactory.getUserService();
        UserInfoDto userInfoDto = userService.getCurrentUser();
        if (Objects.isNull(userInfoDto)) {
            AppAuthService appAuthService = this.serviceFactory.getAppAuthService(appLoginBaseDto.getLoginAppType());
            loginResultDto = appAuthService.appLogin(appLoginBaseDto);
            if (Objects.nonNull(loginResultDto) && loginResultDto.isSuccesss()) {
                this.redisUtils.addStringValue(redisKey, loginResultDto.getToken(), loginResultDto.getExpiresIn());
            }
        } else {
            String token = this.redisUtils.getStringValue(redisKey);
            loginResultDto = new LoginResultDto();
            loginResultDto.setUserInfoDto(userInfoDto);
            loginResultDto.setError(ErrorEnum.SUCCESS);
            loginResultDto.setToken(token);
        }
        if (Objects.nonNull(loginResultDto) && loginResultDto.isSuccesss()) {
            loginResultDto.setError(null);
            loginResultDto.setExpiresIn(0L);
            return ReturnResult.success(loginResultDto);
        }
        if (Objects.nonNull(loginResultDto) && Objects.nonNull(loginResultDto.getError())) {
            return ReturnResult.error(loginResultDto.getError());
        }
        return ReturnResult.error();
    }

    @RequestMapping(value={"/currentUser"})
    @ResponseBody
    @AuthCheck
    public ReturnResult currentUser(HttpServletRequest request) {
        UserService userService = this.serviceFactory.getUserService();
        UserInfoDto userInfoDto = userService.getCurrentUser();
        if (Objects.isNull(userInfoDto)) {
            return ReturnResult.error();
        }
        LoginResultDto loginResultDto = new LoginResultDto();
        loginResultDto.setUserInfoDto(userInfoDto);
        return ReturnResult.success(loginResultDto);
    }

    @RequestMapping(value={"/testlogin"})
    @ResponseBody
    public ReturnResult test(LoginUserBaseDto loginUserBaseDto, HttpServletRequest request, HttpServletResponse response) {
        return this.simpleLogin(loginUserBaseDto, request, response);
    }

    @RequestMapping(value={"/testtokenlogin"})
    @ResponseBody
    public ReturnResult testtokenlogin(String yydm, String accessToken, HttpServletRequest request, HttpServletResponse response) {
        LoginSystemEnum loginSystemEnum = ZdEnum.valueOf(yydm, LoginSystemEnum.class);
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{yydm, accessToken}) || Objects.isNull(loginSystemEnum)) {
            throw new BizException(ErrorEnum.PARAM_NULL);
        }
        LoginTokenDto loginTokenDto = new LoginTokenDto();
        loginTokenDto.setYydm(loginSystemEnum);
        loginTokenDto.setToken(accessToken);
        return this.token(loginTokenDto, request, response);
    }

    @RequestMapping(value={"/testapplogin"})
    @ResponseBody
    public ReturnResult testapplogin(AppLoginBaseDto appLoginBaseDto, HttpServletRequest request, HttpServletResponse response) {
        return this.applogin(appLoginBaseDto, request, response);
    }
}

