/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.interfaces.controller.fjstorage;

import cn.gtmap.ai.core.annotation.auth.AuthCheck;
import cn.gtmap.ai.core.base.ReturnResult;
import cn.gtmap.ai.core.enums.EncryptTypeEnum;
import cn.gtmap.ai.core.enums.ErrorEnum;
import cn.gtmap.ai.core.exception.BizException;
import cn.gtmap.ai.core.service.ServiceFactory;
import cn.gtmap.ai.core.service.setting.application.AiXtFjpzService;
import cn.gtmap.ai.core.service.setting.query.AiXtFjpzQuery;
import cn.gtmap.ai.core.service.storage.application.StorageService;
import cn.gtmap.ai.core.service.storage.domain.MultiPartModel;
import cn.gtmap.ai.core.service.storage.domain.StorageModel;
import cn.gtmap.ai.core.utils.encryption.EncryptUtil;
import cn.gtmap.ai.core.utils.redis.RedisUtils;
import com.gtis.common.util.UUIDGenerator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/fj/v1"})
public class FjStorageController {
    private static final Logger log = LoggerFactory.getLogger(FjStorageController.class);
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    private AiXtFjpzService aiXtFjpzService;
    @Autowired
    private ServiceFactory serviceFactory;

    @ResponseBody
    @AuthCheck
    @PostMapping(value={"/initfjcl"})
    public ReturnResult initfjcl(@RequestBody AiXtFjpzQuery query) {
        return ReturnResult.error(this.aiXtFjpzService.initFjclByFjpz(query));
    }

    @ResponseBody
    @PostMapping(value={"/queryFjxxList"})
    @AuthCheck
    public ReturnResult queryFjxxList(@RequestBody MultiPartModel multiPartModel) {
        StorageService storageService = this.serviceFactory.getStorageService();
        List<StorageModel> storageModelList = storageService.queryFjxx(multiPartModel);
        this.process(storageModelList);
        return ReturnResult.success(storageModelList);
    }

    private void process(List<StorageModel> storageModelList) {
        if (CollectionUtils.isEmpty(storageModelList)) {
            return;
        }
        for (StorageModel storageModel : storageModelList) {
            String ticket = UUIDGenerator.generate18();
            String currentNodeId = storageModel.getId();
            this.redisUtils.addStringValue("rest:fjid:" + EncryptUtil.encryptStr(ticket, EncryptTypeEnum.MD5Salt), currentNodeId, 600L);
            storageModel.setDownTicket(ticket);
            if (!CollectionUtils.isNotEmpty(storageModel.getChildren())) continue;
            this.process(storageModel.getChildren());
        }
    }

    @ResponseBody
    @GetMapping(value={"/showFile"})
    @AuthCheck
    public void showFile(String currentNodeId, HttpServletResponse httpServletResponse) {
        MultiPartModel multiPartModel = new MultiPartModel();
        multiPartModel.setCurrentNodeId(currentNodeId);
        StorageService storageService = this.serviceFactory.getStorageService();
        storageService.showFile(multiPartModel, httpServletResponse);
    }

    @ResponseBody
    @GetMapping(value={"/showFile/{fjyydm}/{ticket}", "/showFile/{ticket}"})
    public void showFileRest(@PathVariable(value="fjyydm", required=false) String fjyydm, @PathVariable(value="ticket") String ticket, HttpServletResponse httpServletResponse) {
        String currentNodeId = this.redisUtils.getStringValue("rest:fjid:" + EncryptUtil.encryptStr(ticket, EncryptTypeEnum.MD5Salt));
        if (StringUtils.isBlank((CharSequence)currentNodeId)) {
            throw new BizException(ErrorEnum.TICKET_TIMEOUT);
        }
        MultiPartModel multiPartModel = new MultiPartModel();
        multiPartModel.setCurrentNodeId(currentNodeId);
        StorageService storageService = this.serviceFactory.getStorageService(fjyydm);
        storageService.showFile(multiPartModel, httpServletResponse);
    }

    @ResponseBody
    @GetMapping(value={"/downFile/{fjyydm}/{ticket}", "/downFile/{ticket}"})
    public void downFile(@PathVariable(value="fjyydm", required=false) String fjyydm, @PathVariable String ticket, HttpServletResponse httpServletResponse) {
        String currentNodeId = this.redisUtils.getStringValue("rest:fjid:" + EncryptUtil.encryptStr(ticket, EncryptTypeEnum.MD5Salt));
        if (StringUtils.isBlank((CharSequence)currentNodeId)) {
            throw new BizException(ErrorEnum.TICKET_TIMEOUT);
        }
        MultiPartModel multiPartModel = new MultiPartModel();
        multiPartModel.setCurrentNodeId(currentNodeId);
        multiPartModel.setSfxz(true);
        StorageService storageService = this.serviceFactory.getStorageService(fjyydm);
        storageService.showFile(multiPartModel, httpServletResponse);
    }
}

