/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.config;

import cn.gtmap.ai.core.enums.DbEnum;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;

@Configuration
@Order(value=-2147483648)
public class RuleEnvironmentHandle
implements BeanPostProcessor {
    @Autowired
    private ConfigurableEnvironment env;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSourceProperties) {
            ((DataSourceProperties)bean).setDriverClassName(this.dataSourceDriverName(this.env.getProperty("spring.datasource.url")));
        }
        return bean;
    }

    private String dataSourceDriverName(String url) {
        String driverName = "oracle.jdbc.driver.OracleDriver";
        if (Objects.nonNull(url)) {
            if (url.contains(DbEnum.MYSQL.getDatabase())) {
                driverName = "com.mysql.cj.jdbc.Driver";
            } else if (url.contains(DbEnum.ORACLE.getDatabase())) {
                driverName = "oracle.jdbc.driver.OracleDriver";
            } else if (url.contains(DbEnum.KB.getDatabase())) {
                driverName = "com.kingbase8.Driver";
            } else if (url.contains(DbEnum.PG.getDatabase())) {
                driverName = "org.postgresql.Driver";
            } else if (url.contains(DbEnum.OSCAR.getDatabase())) {
                driverName = "com.oscar.Driver";
            } else if (url.contains(DbEnum.DM.getDatabase())) {
                driverName = "dm.jdbc.driver.DmDriver";
            }
        }
        return driverName;
    }
}

