/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.config;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class KaptchaConfig {
    @Value(value="${kaptcha.border:no}")
    private String border;
    @Value(value="${kaptcha.border.color:blue}")
    private String borderColor;
    @Value(value="${kaptcha.textproducer.font.color:20,68,106}")
    private String textproducerFontColor;
    @Value(value="${kaptcha.textproducer.font.size:30}")
    private String textproducerFontSize;
    @Value(value="${kaptcha.textproducer.font.names:\u5b8b\u4f53,\u6977\u4f53}")
    private String textproducerFontNames;
    @Value(value="${kaptcha.textproducer.char.length:4}")
    private String textproducerCharLength;
    @Value(value="${kaptcha.image.width:120}")
    private String imageWidth;
    @Value(value="${kaptcha.image.height:40}")
    private String imageHeight;
    @Value(value="${kaptcha.session.key:code}")
    private String sessionKey;
    @Value(value="${kaptcha.noise.color:255,96,0}")
    private String noiseColor;
    @Value(value="${kaptcha.obscurificator.impl: }")
    private String obscurificatorImpl;
    @Value(value="${kaptcha.noise.impl:com.google.code.kaptcha.impl.NoNoise}")
    private String noiseImpl;

    @Bean(name={"captchaProducer"})
    public DefaultKaptcha getKaptchaBean() {
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        Properties properties = new Properties();
        properties.setProperty("kaptcha.border", this.border);
        properties.setProperty("kaptcha.border.color", this.borderColor);
        properties.setProperty("kaptcha.textproducer.font.color", this.textproducerFontColor);
        properties.setProperty("kaptcha.textproducer.font.size", this.textproducerFontSize);
        properties.setProperty("kaptcha.textproducer.font.names", this.textproducerFontNames);
        properties.setProperty("kaptcha.textproducer.char.length", this.textproducerCharLength);
        properties.setProperty("kaptcha.image.width", this.imageWidth);
        properties.setProperty("kaptcha.image.height", this.imageHeight);
        properties.setProperty("kaptcha.session.key", this.sessionKey);
        properties.setProperty("kaptcha.noise.color", this.noiseColor);
        if (StringUtils.isNotBlank((CharSequence)this.obscurificatorImpl)) {
            properties.setProperty("kaptcha.obscurificator.impl", this.obscurificatorImpl);
        }
        properties.setProperty("kaptcha.noise.impl", this.noiseImpl);
        Config config = new Config(properties);
        defaultKaptcha.setConfig(config);
        return defaultKaptcha;
    }
}

