/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.encryption.sm2;

import cn.gtmap.ai.core.utils.encryption.sm2.Sm2lib;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.gm.GMNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sm2lib2 {
    private static Logger logger = LoggerFactory.getLogger(Sm2lib.class);
    private static final String PUBLIC_KEY = "0410ad277ad243570d37be0decff5a498ca9bbb8ed66ba80321383b272f55041b8f4219d808c035bead2353cae3d23b6550201f492b8d9feefe32920418f1cf039";
    private static final String PRIVATE_KEY = "98c8b4a9c0b58e620e1645e817e632190da5c993c04b27b3a5b61b3673498ef1";
    private static final String GM_NAMED = "sm2p256v1";
    private static final String TAG = "04";

    public static String decode(String cipherData) {
        if (StringUtils.isBlank((CharSequence)cipherData)) {
            return cipherData;
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)cipherData, (CharSequence)TAG)) {
            return cipherData;
        }
        byte[] cipherDataByte = Hex.decode((String)cipherData);
        BigInteger privateKeyD = new BigInteger(PRIVATE_KEY, 16);
        X9ECParameters sm2Parameters = GMNamedCurves.getByName((String)GM_NAMED);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2Parameters.getCurve(), sm2Parameters.getG(), sm2Parameters.getN());
        ECPrivateKeyParameters privateKeyParameters = new ECPrivateKeyParameters(privateKeyD, domainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, (CipherParameters)privateKeyParameters);
        try {
            byte[] dd = sm2Engine.processBlock(cipherDataByte, 0, cipherDataByte.length);
            byte[] arrayOfBytes = Base64.getDecoder().decode(dd);
            return new String(arrayOfBytes, Charset.forName(String.valueOf(StandardCharsets.UTF_8)));
        }
        catch (InvalidCipherTextException e) {
            logger.error("SM2\u89e3\u5bc6\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }

    public static String encode(String plaintext) {
        return Sm2lib2.encode(plaintext, PUBLIC_KEY);
    }

    public static String encode(String plaintext, String publicKey) {
        if (StringUtils.isBlank((CharSequence)publicKey)) {
            logger.error("SM2\u52a0\u5bc6\u5931\u8d25\uff1a", (Object)"\u516c\u94a5\u4e3a\u7a7a");
        }
        X9ECParameters sm2Parameters = GMNamedCurves.getByName((String)GM_NAMED);
        ECDomainParameters domainParameters = new ECDomainParameters(sm2Parameters.getCurve(), sm2Parameters.getG(), sm2Parameters.getN());
        ECPoint pukPoint = sm2Parameters.getCurve().decodePoint(Hex.decode((String)publicKey));
        ECPublicKeyParameters publicKeyParameters = new ECPublicKeyParameters(pukPoint, domainParameters);
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, (CipherParameters)new ParametersWithRandom((CipherParameters)publicKeyParameters, new SecureRandom()));
        byte[] arrayOfBytes = null;
        try {
            byte[] in = Base64.getEncoder().encode(plaintext.getBytes(StandardCharsets.UTF_8));
            arrayOfBytes = sm2Engine.processBlock(in, 0, in.length);
            return Hex.toHexString((byte[])arrayOfBytes);
        }
        catch (Exception e) {
            logger.error("SM2\u52a0\u5bc6\u5931\u8d25\uff1a", (Throwable)e);
            return null;
        }
    }
}

