/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.ai.core.utils.doc.model;

import cn.gtmap.ai.core.utils.doc.model.Merger;
import cn.gtmap.ai.core.utils.doc.model.TableDetailData;
import com.deepoove.poi.XWPFTemplate;
import com.deepoove.poi.exception.RenderException;
import com.deepoove.poi.plugin.table.LoopRowTableRenderPolicy;
import com.deepoove.poi.template.ElementTemplate;
import com.deepoove.poi.template.run.RunTemplate;
import com.deepoove.poi.util.TableTools;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;

public class MineLoopRowTableRenderPolicy
extends LoopRowTableRenderPolicy {
    private boolean onSameLine;

    public void render(ElementTemplate eleTemplate, Object data, XWPFTemplate template) {
        if (!(data instanceof TableDetailData)) {
            return;
        }
        try {
            RunTemplate runTemplate = (RunTemplate)eleTemplate;
            XWPFRun run = runTemplate.getRun();
            if (!TableTools.isInsideTable((XWPFRun)run)) {
                throw new IllegalStateException("The template tag " + runTemplate.getSource() + " must be inside a table");
            }
            XWPFTableCell tagCell = (XWPFTableCell)((XWPFParagraph)run.getParent()).getBody();
            XWPFTable table = tagCell.getTableRow().getTable();
            TableDetailData detailData = (TableDetailData)data;
            List<Map<String, Object>> rowList = detailData.getRowList();
            List<Merger> mergeList = detailData.getMergeList();
            int templateRowIndex = this.getTemplateRowIndex(tagCell);
            XWPFTableRow firstRow = table.getRow(templateRowIndex);
            ArrayList nameList = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)firstRow.getTableCells()) && CollectionUtils.isNotEmpty(mergeList)) {
                for (XWPFTableCell cell : firstRow.getTableCells()) {
                    nameList.add(cell.getText());
                }
                Iterator<Merger> mergerIterator = mergeList.iterator();
                while (mergerIterator.hasNext()) {
                    Merger merger = mergerIterator.next();
                    if (nameList.contains("[" + merger.getColName() + "]")) continue;
                    mergerIterator.remove();
                }
            }
            super.render(eleTemplate, rowList, template);
            tagCell = (XWPFTableCell)((XWPFParagraph)run.getParent()).getBody();
            table = tagCell.getTableRow().getTable();
            List rows = table.getRows();
            if (CollectionUtils.isNotEmpty(mergeList) && CollectionUtils.isNotEmpty((Collection)rows)) {
                for (int i = templateRowIndex; i < rows.size(); ++i) {
                    XWPFTableRow rowData = (XWPFTableRow)rows.get(i);
                    Iterator<Merger> mergerIterator = mergeList.iterator();
                    while (mergerIterator.hasNext()) {
                        Merger merger = mergerIterator.next();
                        int cellNum = nameList.indexOf("[" + merger.getColName() + "]");
                        XWPFTableCell cell = rowData.getCell(cellNum);
                        if (null == cell || !StringUtils.equals((CharSequence)merger.getColValue(), (CharSequence)cell.getText())) continue;
                        Integer listSize = merger.getListSize();
                        if (listSize > 1) {
                            int lastRow = i + listSize - 1;
                            if (lastRow >= rows.size()) {
                                lastRow = rows.size() - 1;
                            }
                            TableTools.mergeCellsVertically((XWPFTable)table, (int)cellNum, (int)i, (int)lastRow);
                        }
                        mergerIterator.remove();
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RenderException("HackLoopTable for " + eleTemplate + "error: " + e.getMessage(), e);
        }
    }

    private int getTemplateRowIndex(XWPFTableCell tagCell) {
        XWPFTableRow tagRow = tagCell.getTableRow();
        return this.onSameLine ? this.getRowIndex(tagRow) : this.getRowIndex(tagRow) + 1;
    }

    private int getRowIndex(XWPFTableRow row) {
        List rows = row.getTable().getRows();
        return rows.indexOf(row);
    }
}

